#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <inttypes.h>
// #include <sys/prctl.h>

#include "include/BaiduRtcInterface.h"

#ifndef PRId64
#define PRId64 "lld"
#endif

#ifndef RTLD_DEEPBIND
#define RTLD_DEEPBIND 0
#endif

const char* Help =
"\
push_demo\n\
Copyright 2022 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Usage:\n\
    ./push_demo $(APPID_GET_FROM_BAIDU)\n\
\n\
";

baidurtc::BaiduRtcRoomClient *g_BrtcClient = nullptr;
volatile bool g_StopFlag = false;
volatile bool gInsertSEI = false;
#define FILE_PCM_AUIDO_IN_CHANNEL    (1)
#define FILE_PCM_AUIDO_IN_FREQUENCY  (16000)

int64_t CurrentTimeMillis()
{
    int64_t timems = std::chrono::duration_cast<std::chrono::milliseconds>(
            std::chrono::system_clock::now().time_since_epoch()
        ).count();
    return timems;
}

class myListener:public IRtcMessageListener
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %" PRId64 ", Name: %s.\n",msg.data.feedId,msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %" PRId64 ".\n",msg.data.feedId);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                printf("stream up, feedid/id : %" PRId64 " send video/audio now.\n", msg.data.feedId);

                g_StopFlag = false;
                std::thread([]()
                {
                    std::fstream  fs("./myvideo.h264");
                    std::stringstream  ss;

                    ss << fs.rdbuf();
                    // prctl(PR_SET_NAME, "h264_input_thread.");
                    printf("h264.length(): %ld\n", ss.str().length());
                    int t_len = ss.str().length();
                    unsigned char* buf = new unsigned char[t_len];
                    unsigned char* frame = new unsigned char[1024 * 64];
                    memcpy(buf, ss.str().data(), t_len);
                    int packet_len = 1400;
                    int j = 0;
                    int cur = 0;
                    int nal_len = 0;

                    auto get_next_nalu = [&]() {
                        if (cur == t_len) {
                            cur = 0;
                        }
                        int i = cur;
                        if (buf[cur] == 0x00 && buf[cur + 1] == 0x00 && buf[cur + 2] == 0x00 && buf[cur + 3] == 0x01) {
                            i = cur + 4;
                            // printf("found 0x0000 0001, cur = %d, i = %d\n", cur, i);
                        }
                        else if (buf[cur] == 0x00 && buf[cur + 1] == 0x00 && buf[cur + 2] == 0x01) {
                            i = cur + 3;
                            // printf("found 0x0000 01, cur = %d, i = %d\n", cur, i);
                        }
                        bool found_hd = false;
                        while (i < t_len - 4) {
                            if (buf[i] == 0x00 && buf[i + 1] == 0x00 &&
                                ((buf[i + 2] == 0x00 && buf[i + 3] == 0x01) || buf[i + 2] == 0x01) ) {
                                if (i - cur < 60 ) { // SPS, PPS should send with I frame.
                                    i++;
                                    continue;
                                }
                                found_hd = true;
                                nal_len = i - cur;
                                // printf("found nexe header, cur = %d, i = %d, len = %d\n", cur, i, nal_len);
                                // printf("next-h: %d, %2X %2X %2X %2X %2X %2X %2X\n", i, buf[i-4], buf[i-3], buf[i-2], buf[i-1], buf[i+3], buf[i+4], buf[i+5]);
                                break;
                            }
                            ++i;
                        }
                        if (!found_hd) {
                            nal_len = t_len - cur;
                            // printf("not found nexe header, cur = %d, i = %d, len = %d\n", cur, i, nal_len);
                        }
                    };

                    auto pre_send_time = std::chrono::system_clock::now();
                    for (int i=0; i < 2000000; i++) { //need streaming control.
                        get_next_nalu();
                        if (cur == 0 ) {
                            // printf("shs video loop time %lld----------> pushing h264 index: %d , cur: %d,  nal_len: %d\n", CurrentTimeMillis(), i, cur, nal_len);
                        }

                        if (gInsertSEI) {
                            gInsertSEI = false;
                            unsigned char SEI[50];

                            SEI[0] = 0x00;
                            SEI[1] = 0x00;
                            SEI[2] = 0x00;
                            SEI[3] = 0x01; // NAL header
                            SEI[4] = 0x06; // NALType SEI
                            SEI[5] = 100;  // SEI code
                            SEI[6] = 9;   // info length
                            SEI[7] = 'm';  // info data...
                            SEI[8] = 'y';
                            SEI[9] = 't';
                            SEI[10] = 'i';
                            SEI[11] = 'm';
                            SEI[12] = 'e';
                            SEI[13] = rand() % 200;
                            SEI[14] = ' ';
                            SEI[15] = '!';

                            memcpy(frame, (const char*)SEI, 16);
                            memcpy(frame + 16, (const char *)buf + cur, nal_len);

                            g_BrtcClient->sendImage((const char*)frame, 16 + nal_len);
                            // printf("shs send SEI frame.");
                        } else {
                            g_BrtcClient->sendImage((const char *)buf + cur,nal_len);
                        }

                        cur += nal_len;
                        std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(40)));
                        if (g_StopFlag) break;
                    }
                    delete[] buf;
                    delete[] frame;
                }).detach();

                std::thread([]()
                {
                    std::fstream  fs("./mypcm.raw");
                    std::stringstream  ss;

                    ss << fs.rdbuf();
                    // prctl(PR_SET_NAME, "pcm_input_thread.");
                    std::cout << "pcm.length(): "<< ss.str().length() << std::endl;
                    int t_len = ss.str().length();
                    int packet_len = (FILE_PCM_AUIDO_IN_FREQUENCY / 100) * 2 * 4 * FILE_PCM_AUIDO_IN_CHANNEL;
                    int j = 0;

                    auto pre_send_time = std::chrono::system_clock::now();
                    for (int i=0; i < 2000000; i++) { //need streaming control.

                        g_BrtcClient->sendAudio(&ss.str()[j],packet_len);
                        std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(40)));
                        if (g_StopFlag) break;

                        j += packet_len;
                        if (j + packet_len > t_len)
                        {
                            j = 0;
                            // printf("loop audio time %lld. \n", CurrentTimeMillis());
                        }
                    }
                }).detach();
            }
            break;
        default:
            break;
        }
    }
} g_myListener;

void setListener(baidurtc::BaiduRtcRoomClient *c,myListener &l)
{
    c->registerRtcMessageListener(&l);
}

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();
typedef void f_enable(int e);
typedef void f_disable(int dis);

int main_push(int argc, char* argv[])
{
    if (argc < 2)
    {
        printf("%s", Help);
        return false;
    }

    void* handle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
    if (handle == NULL) {
        fprintf(stderr, "Could not open sdk: %s\n", dlerror());
        return 1;
    }
    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(handle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(handle, "getBaiduRtcSdkVersion");
    f_enable *enableLog = (f_enable *)dlsym(handle, "enableBaiduRtcLog");
    if (enableLog) {
        enableLog(0); // set 0 to disable logs.
    }

    f_disable *disableEncryption = (f_disable *)dlsym(handle, "disableRTPEncryption");
    if (disableEncryption) {
        disableEncryption(0); // set 1 to disable RTP Encryption.
    }

    printf("BRTC SDK Version is: %s\n",version());

    printf("Calling API\n");

    RtcParameterSettings s;

    g_BrtcClient = createClient();
    setListener(g_BrtcClient, g_myListener);

    s.HasData = false;
    s.HasVideo = true;
    s.HasAudio = true;
    s.AudioINChannel = FILE_PCM_AUIDO_IN_CHANNEL;
    s.AudioINFrequency = FILE_PCM_AUIDO_IN_FREQUENCY;
    s.ImageINType = RTC_IMAGE_TYPE_H264;
    s.AsPublisher = true;
    s.AsListener = false;
    s.AutoPublish = true;

    g_BrtcClient->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
    g_BrtcClient->setAppID(argv[1]/*$(APPID_GET_FROM_BAIDU)*/);
    g_BrtcClient->setMediaServerURL(argc > 2 ? argv[2] : "wss://rtc.exp.bcelive.com/janus");
    g_BrtcClient->setCER("../bin/a.cer");
    // g_BrtcClient->setVideoCodec("h264");
    // g_BrtcClient->setAudioCodec("pcmu");
    // g_BrtcClient->setAudioCodec("wanos");
    // g_BrtcClient->setAudioCodec("isac32");
    // g_BrtcClient->setLiveStreamingURL("rtmp://127.0.0.1/test");
    // g_BrtcClient->setLiveStreamingMix(true);
    // g_BrtcClient->setLiveStreamingMixTemplate("picture_in_picture_bottom_1080p_9_16");

    std::string uid;
    std::ostringstream os;
    os << 1234500000 + rand()/100000;
    uid =  os.str();

    g_BrtcClient->loginRoom(argc > 3 ? argv[3] : "2131",
                            argc > 4 ? argv[4] : uid.c_str(),
                            argc > 5 ? argv[5] : "BRTC SDK push demo",
                            argc > 6 ? argv[6] : "token");

	while (true) {
        printf("**********BaiDuRTC PUSH demo V0.0.4 *********\n");
		printf("Please input i for send one SEI frame; q to Quit.\n");
		char commandid[512];
        memset(commandid,0,sizeof(commandid));
		int ret = scanf("%s", commandid);
		printf("scanf %d.\n", ret);

		if (ret < 0) {
			std::this_thread::sleep_for(std::chrono::milliseconds(20000));
			continue;
		}

        switch (commandid[0])
        {
            case 'i':
                gInsertSEI = true;
                break;
        }

		if (commandid[0] == 'q') break;
    }

    g_StopFlag = true;
    std::this_thread::sleep_for(std::chrono::milliseconds(100));
    g_BrtcClient->logoutRoom();
    printf("logoutRoom OK.\n");
    g_BrtcClient->Destory();
    g_BrtcClient = nullptr;
    printf("Destory OK.\n");

    printf("API returned %d\n", 123);
    if (dlclose(handle) != 0) {
        fprintf(stderr, "Could not close plugin: %s\n", dlerror());
        return 1;
    }
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_push(argc, argv);

    return res;
}