
#include <iostream>
#include <memory>
#include <string>

#include <grpc++/grpc++.h>

#include "brtcdha.grpc.pb.h"

using grpc::Server;
using grpc::ServerBuilder;
using grpc::ServerContext;
using grpc::Status;

// Logic and data behind the server's behavior.
class BRTCDHAServiceImpl final : public DigitalHumanAgentService::Service {
  std::shared_ptr<::grpc::ServerReaderWriter<::Response, ::Audio> > audio_stream_;
  Status audio(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::Response, ::Audio>* stream) override {

    Audio a;
    stream->Read(&a);

    std::cout << "Server called audio data 1: "<< a.audio() << std::endl;

    a.clear_audio();
    stream->Read(&a);

    std::cout << "Server called audio data 2: "<< a.audio() << std::endl;

    std::cout << "Server called audio " << std::endl;
    return Status::OK;
  }
  Status image(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::Response, ::Image>* stream) override {
    Image a;
    stream->Read(&a);
    std::cout << "Server called image data 1: "<< a.image().size() << std::endl;

    a.clear_image();
    stream->Read(&a);
    std::cout << "Server called image data 2: "<< a.image().size() << std::endl;
    return Status::OK;
  }

  Status data(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::Response, ::Data>* stream) override {
    Data a;
    stream->Read(&a);
    std::cout << "Server called text data 1: "<< a.data() << std::endl;

    a.clear_data();
    stream->Read(&a);
    std::cout << "Server called text data 2: "<< a.data()<< std::endl;
    return Status::OK;
  }

};

void RunServer() {
  std::string server_address("0.0.0.0:8090");
  BRTCDHAServiceImpl service;

  ServerBuilder builder;
  // Listen on the given address without any authentication mechanism.
  builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
  // Register "service" as the instance through which we'll communicate with
  // clients. In this case it corresponds to an *synchronous* service.
  builder.RegisterService(&service);
  // Finally assemble the server.
  std::unique_ptr<Server> server(builder.BuildAndStart());
  std::cout << "Server listening on " << server_address << std::endl;

  // Wait for the server to shutdown. Note that some other thread must be
  // responsible for shutting down the server for this call to ever return.
  server->Wait();
}

int main(int argc, char** argv) {
  RunServer();

  return 0;
}