#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <inttypes.h>

#include "include/BaiduRtcInterface.h"

#ifndef PRId64
#define PRId64 "lld"
#endif

#ifndef RTLD_DEEPBIND
#define RTLD_DEEPBIND 0
#endif

const char* Help =
"\
pull_demo\n\
Copyright 2021 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Usage:\n\
    ./pull_demo $(APPID_GET_FROM_BAIDU)\n\
\n\
";

baidurtc::BaiduRtcRoomClient *g_BrtcClient = nullptr;

class myListener:public IRtcMessageListener,
                public IAudioFrameObserver,
                public IVideoFrameObserver,
                public IDataFrameObserver
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %" PRId64 ", Name: %s.\n",msg.data.feedId,msg.extra_info);
                // g_BrtcClient->subscribeStreaming(std::to_string(msg.data.feedId).c_str(), nullptr, nullptr, nullptr);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %" PRId64 ".\n",msg.data.feedId);
                // g_BrtcClient->stopSubscribeStreaming(std::to_string(msg.data.feedId).c_str());
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                printf("stream up, send/got video now.\n");
            }
            break;
        case RtcMessageType::RTC_ROOM_EVENT_ON_USER_MESSAGE:
            {
                printf("Got User Message id: %" PRId64 ", msg: %s.\n", msg.data.feedId, msg.extra_info);
            }
            break;
        default:
            break;
        }
    }
    void onFrame(int64_t feedid, const char *img,  int len,  RtcImageType imgtype, int width, int height) override 
    {
        printf("got VideoData feed %" PRId64 ", data len = %d.\n",feedid, len);
    }
    void onAudioData(int64_t feedid, const char *audio, int len, int samlplerate, int channels) override 
    {
        printf("got AudioData feed %" PRId64 ", data len = %d.\n",feedid, len);
    }
    void onTextData(int64_t feedid, const char *data, int len) override
    {
        std::string msg(data,len);
        printf("got TextData feed %" PRId64 ", data len = %d, text: %s.\n",feedid, len, msg.c_str());
    }

} g_myListener;

void setListener(baidurtc::BaiduRtcRoomClient *c,myListener &l)
{
    c->registerRtcMessageListener(&l);

    IVideoFrameObserver* iVfo[2];
    iVfo[0] = &l;
    c->registerVideoFrameObserver(iVfo,1);

    IAudioFrameObserver* iAfo[2];
    iAfo[0] = &l;
    c->registerAudioFrameObserver(iAfo,1);

    IDataFrameObserver* iDfo[2];
    iDfo[0] = &l;
    c->registerDataFrameObserver(iDfo,1);
}

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();
typedef void f_enableLog(int e);
typedef void f_disable(int dis);

int main_pull(int argc, char* argv[])
{
    if (argc < 2)
    {
        printf("%s", Help);
        return false;
    }

    void* handle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
    if (handle == NULL) {
        fprintf(stderr, "Could not open sdk: %s\n", dlerror());
        return 1;
    }
    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(handle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(handle, "getBaiduRtcSdkVersion");
    f_enableLog *enableLog = (f_enableLog*)dlsym(handle, "enableBaiduRtcLog");
    f_enableLog *enableReviewer = (f_enableLog*)dlsym(handle, "setSDKAsReviewer");
    f_enableLog *enableLargeRoom = (f_enableLog*)dlsym(handle, "setSDKAsLargeRoom");

    if (enableLog) {
        enableLog(0); // set 0 to disable logs.
    }

    f_disable *disableEncryption = (f_disable *)dlsym(handle, "disableRTPEncryption");
    if (disableEncryption) {
        disableEncryption(0); // set 1 to disable RTP Encryption.
    }

    printf("BRTC.Linux.SDK Version is: %s\n",version());

    printf("Calling API\n");

    volatile bool g_StopFlag = false;
    RtcParameterSettings s;

    g_BrtcClient = createClient();
    setListener(g_BrtcClient, g_myListener);

    s.HasData = false;
    s.HasVideo = true;
    s.HasAudio = true;
    s.AudioOUTChannel = 1;
    s.AudioOUTFrequency = 16000;
    s.AsPublisher = false;
    s.AsListener = true;

    s.AutoSubscribe = true;// set to false for later call subscribeStreaming.
    g_BrtcClient->setFeedId("999999");// set to 0 for later call subscribeStreaming with feedid.

    g_BrtcClient->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
    g_BrtcClient->setAppID(argv[1]/*$(APPID_GET_FROM_BAIDU)*/);
    g_BrtcClient->setMediaServerURL(argc > 2 ? argv[2] : "wss://rtc.exp.bcelive.com/janus");
    g_BrtcClient->setCER("../bin/a.cer");

    if (argc > 3) {
        g_BrtcClient->setVideoCodec(argv[3]);
    }

    if (argc > 4) {
        g_BrtcClient->setFeedId(argv[4]);
    }

    // g_BrtcClient->setDumpVideoOutput("./dump_video.h264");
    // g_BrtcClient->setDumpAudioOutput("./dump_audio-16k-1ch.pcm.raw");

    std::string uid;
    std::ostringstream os;
    os << 1234500000 + rand()/100000;
    uid =  os.str();

    g_BrtcClient->loginRoom("2131",uid.c_str(),"BRTC Linux SDK pull demo","token");

	while (true) {
		printf("**********BaiDuRTC PULL demo V0.0.2 *********\n");
		printf("Please input q to Quit.\n");
		char commandid[512];
        memset(commandid,0,sizeof(commandid));
		int ret = scanf("%s", commandid);
		printf("scanf %d.\n", ret);

		if (ret < 0) {
			std::this_thread::sleep_for(std::chrono::milliseconds(20000));
			continue;
		}

		if (commandid[0] == 'q') break;
    }

    g_BrtcClient->logoutRoom();
    printf("logoutRoom OK.\n");
    g_BrtcClient->Destory();
    g_BrtcClient = nullptr;
    printf("Destory OK.\n");

    printf("API returned %d\n", 123);
    if (dlclose(handle) != 0) {
        fprintf(stderr, "Could not close plugin: %s\n", dlerror());
        return 1;
    }
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_pull(argc, argv);

    return res;
}