/*
 *
 * Copyright 2015 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <iostream>
#include <memory>
#include <string>

class BRTCDHAClient {
 public:
  // Assembles the client's payload, sends it and presents the response back
  // from the server.
  std::string send_audio(const std::string& audio_data);
  std::string send_image(const std::string& video_data);
  std::string send_data(const std::string&  text_data);

  static BRTCDHAClient *getNewBRTCDHAClient(const std::string& DHAURL, const std::string& RoomName);

  static BRTCDHAClient *getGlobalBRTCDHAClient();

  void Detete();

private:
   BRTCDHAClient(const std::string& DHAURL, const std::string& RoomName);

   static BRTCDHAClient *gGlobalBRTCDHAClient;

   std::string mRoomName;

 private:
 #ifdef __SHOW_MEMBERS__
  std::unique_ptr<DigitalHumanAgentService::Stub> stub_;
  std::shared_ptr<::grpc::ClientReaderWriter<::Audio, ::Response> > stream_;
  std::shared_ptr<::grpc::ClientReaderWriter<::Image, ::Response> > image_stream_;
  std::shared_ptr<::grpc::ClientReaderWriter<::Data, ::Response> > data_stream_;
  ClientContext mContext;
  ClientContext mImageContext;
  ClientContext mDataContext;
  std::string mBuffer10Count;
  ::Audio mAudio;
  ::Image mImage;
  ::Data mData;
 #endif
};
