package com.baidu.rtc.sample.util;


import android.os.Build;

import com.baidu.rtc.model.Constants;

public class Utils {

    /** 获取设备uid */
    public static int getDeviceUid() {
        return 78657895 + (Build.SERIAL.hashCode() % 100000) + (int) (Math.random() * 10000);
    }

    public static String getStateString(int state) {
        String result = "";
        switch (state) {
            case Constants.CONNECTION_STATE_DISCONNECTED: {
                result = "CONNECTION_STATE_DISCONNECTED";
                break;
            }
            case Constants.CONNECTION_STATE_CONNECTING: {
                result = "CONNECTION_STATE_CONNECTING";
                break;
            }
            case Constants.CONNECTION_STATE_CONNECTED: {
                result = "CONNECTION_STATE_CONNECTED";
                break;
            }
            case Constants.CONNECTION_STATE_RECONNECTING: {
                result = "CONNECTION_STATE_RECONNECTING";
                break;
            }
            case Constants.ERR_LOGIN_ROOM_PARAMS: {
                result = "ERR_LOGIN_ROOM_PARAMS";
                break;
            }
            case Constants.ERR_CHANNEL_IO_EXCEPTION: {
                result = "ERR_CHANNEL_IO_EXCEPTION";
                break;
            }
            case Constants.ERR_CHANNEL_DISCARD_BY_REMOTE: {
                result = "ERR_CHANNEL_DISCARD_BY_REMOTE";
                break;
            }
            case Constants.ERR_AUDIO_DEVICE_RECORD: {
                result = "ERR_AUDIO_DEVICE_RECORD";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL0: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL0";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL1: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL1";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL2: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL2";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL3: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL3";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL4: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL4";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL5: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL5";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL6: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL6";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL7: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL7";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL8: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL8";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL9: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL9";
                break;
            }
            default: {
                result = "unknow state!";
                break;
            }
        }
        return result;
    }
}
