package com.baidu.rtc.sample.util;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public class UIUtils {
    public static int getScreenWidth(Context context) {
        WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        int width = outMetrics.widthPixels;

        return width;

    }

    public static int getScreenHeight(Context context) {
        WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        int height = outMetrics.heightPixels;

        return height;
    }

    public static int dip2px(Context context, int dp) {
        return dp2px(context, dp);
    }

    public static int dp2px(Context context, int dp) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dp * scale + 0.5f);
    }

    public static float sp2px(Resources resources, float sp) {
        final float scale = resources.getDisplayMetrics().scaledDensity;
        return sp * scale;
    }

    public static String toFormatTime(int seconds) {
        if (seconds < 0) {
            seconds = 0;
        }

        int minute = 0;
        int second = 0;

        second = seconds % 60;
        seconds -= second;
        if (seconds > 0) {
            seconds /= 60;
            minute = seconds % 60;
        }
        if (second < 10) {
            return "0" + minute + ":0" + second;
        } else {
            return "0" + minute + ":" + second;
        }
    }
}
