package com.baidu.rtc.sample.util;

import android.database.Cursor;
import android.media.MediaMetadataRetriever;

import java.io.Closeable;

/**
 * BdCloseHelper
 *
 * @author zhoujunjiang
 * @version V1.0
 * @since 2018/11/30
 */
public class BdCloseHelper {

    /**
     * 关闭给定的流.
     */
    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            } catch (Throwable e) {
//                BdLog.e(e.getMessage());
            }
        }
    }

    /**
     * 关闭给定的游标
     */
    public static void close(Cursor c) {
        if (c != null) {
            try {
                c.close();
            } catch (Exception e) {
//                BdLog.e(e.getMessage());
            }
        }
    }

    /**
     * 关闭 MediaMetadataRetriever
     */
    public static void close(MediaMetadataRetriever retriever) {
        if (retriever != null) {
            try {
                retriever.release();
            } catch (Exception e) {
//                BdLog.e(e);
            }
        }
    }
}
