package com.baidu.rtc.sample.splitscreen;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.baidu.rtc.sample.util.ScreenUtil;

public class ToolsView  {
    public static final int STYLE_1 = 100;
    public static final int STYLE_2 = 101;
    public static final int STYLE_3 = 102;
    private static final String TAG = "ToolsView";
    private Context mContext;
    private TextView mTextView1;
    private TextView mTextView2;
    private TextView mTextView3;
    private Callback mCallback;

    public ToolsView() {

    }
    public View onCreate(Context context, Callback callback) {
        mContext = context;
        mCallback = callback;

        RelativeLayout root = new RelativeLayout(mContext);
        root.setGravity(Gravity.BOTTOM);
        LinearLayout ll = new LinearLayout(mContext);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.BOTTOM;
        params.bottomMargin = 80;
        params.leftMargin = 30;
        root.addView(ll, params);
        mTextView1 = createTextView(mContext, ll, "style_1");
        mTextView2 = createTextView(mContext, ll, "style_2");
        mTextView3 = createTextView(mContext, ll, "style_3");

        mTextView1.setOnClickListener(mTextViewClickListener);
        mTextView2.setOnClickListener(mTextViewClickListener);
        mTextView3.setOnClickListener(mTextViewClickListener);

        return root;
    }

    public static void changeLayoutParams(View view, int type) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) view.getLayoutParams();
        if (params == null) {
            params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT);
        }
        int w = (int) ScreenUtil.getScreenWidth();
        int h = (int) ScreenUtil.getScreenHeight();

        Log.i(TAG, "ScreenUtil == w:" + w + ", h:" + h);

        int itemWidth = 700;
        int itemHeight = 700;
        if (type == STYLE_1) {
            /** 530*432px */
            itemWidth = 530;
            itemHeight = 432;
        } else if (type == STYLE_2) {
            /** 530*530 */
            itemWidth = 530;
            itemHeight = 530;
        } else if (type == STYLE_3){
            /** 700*700 */
            itemWidth = 700;
            itemHeight = 700;
        }
        params.width = itemWidth;
        params.height = itemHeight;
        view.setLayoutParams(params);
    }

    private View.OnClickListener mTextViewClickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            if (v == mTextView1) {
                Log.i(TAG, "mTextView1 click!");
                ToolsView.this.onClick(STYLE_1);
            } else if (v == mTextView2) {
                Log.i(TAG, "mTextView2 click!");
                ToolsView.this.onClick(STYLE_2);
            } else if (v == mTextView3) {
                Log.i(TAG, "mTextView3 click!");
                ToolsView.this.onClick(STYLE_3);
            }
        }
    };

    private void onClick(int type) {
        if (mCallback != null) {
            mCallback.onViewClick(type);
        }
    }

    private static TextView createTextView(Context context, LinearLayout root, String txt) {

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        params.leftMargin = 10;

        TextView tv = new TextView(context);
        tv.setTextColor(Color.WHITE);
        tv.setTextSize(14f);
        tv.setText(txt);
        root.addView(tv, params);
        return tv;
    }

    public interface Callback {
        void onViewClick(int type);
    }
}
