package com.baidu.rtc.sample;

import android.app.Application;
import android.content.Context;
import androidx.multidex.MultiDex;

import com.baidu.rtc.sample.data.ContextConstant;
import com.baidu.rtc.sample.util.CrashUtil;
import com.tencent.bugly.crashreport.CrashReport;

public class BdRtcApplication extends Application {
    private static final String TAG = "BdRtcApplication";

    @Override
    public void onCreate() {
        super.onCreate();
        Context context = getApplicationContext();

        ContextConstant.setContext(context);

        new CrashUtil().initCrashHandler();
        CrashReport.initCrashReport(context, "656b522d12", false);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(base);
    }
}
