#!/usr/bin/env python

"""Chat using realtime API."""

# Help: https://cloud.baidu.com/doc/RTC/s/Jmakuvimy

import asyncio
from websockets.asyncio.client import connect
import time
import sys

ws = None

async def sendloop():
    """
    无限循环发送消息
    """
    global ws
    await asyncio.sleep(3)
    while True:
        await ws.send("[T]:你是谁?", text=True)
        await asyncio.sleep(10)

async def chat(uri):
    """
    与指定URI的WebSocket服务器进行聊天，并打印收到的消息。
    Args:
        uri (str): WebSocket服务器的URI，例如"ws://localhost:8080/chat"。
    """
    async with connect(uri) as websocket:
        print("connected")
        global ws
        ws = websocket
        while True:
            message = await websocket.recv()
            if (isinstance(message, str)):
                print('rx Text: ' + message)
                if message.startswith('[E]:[LIC]:[MUST]'):
                    # 处理授权信息
                    lic_message = '[E]:[LIC]:[ACTIVE]:{"devId":"DDD","uId":"YYY","licKey":"xxx"}'
                    await websocket.send(lic_message, text=True)
            else:
                print('rx Binary, len:', len(message))

def close():
    """
    关闭连接，并打印"close"信息。
    """
    print("close")
    global ws
    ws.close()

if __name__ == "__main__":
    try:
        realtime_uri = "ws://localhost:8654/v1/realtime"
        if (len(sys.argv) > 1):
            realtime_uri = sys.argv[1]
        asyncio.get_event_loop().run_until_complete(asyncio.gather(chat(realtime_uri), sendloop()))
    except KeyboardInterrupt:
        sys.exit(0)
