//
//  RTCVideoBufferNode.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/6/8.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

NS_ASSUME_NONNULL_BEGIN

@protocol RTCVideoBufferOutput;

/// 视频管线中的可输入节点，作为其他节点的 输出目标，可以接受外部视频数据输入
@protocol RTCVideoBufferInput <NSObject>

/// 接收输入数据
- (void)inputVideoFrame:(RtcVideoFrame *)videoFrame fromOutput:(id<RTCVideoBufferOutput> _Nullable)output;

/// 从上游节点接收消息，默认向下传播
- (void)recvMessage:(NSString *)message fromOutput:(id<RTCVideoBufferOutput> _Nullable)output;

@end

@protocol RTCVideoBufferMultiInput <NSObject>

/// 添加输入源
- (void)addSource:(NSInteger)tag;

/// 移除输入源
- (void)removeSource:(NSInteger)tag;

/// 接受输入数据
/// @discussion videoFrame 传入 nil 时等同 removeSource
- (void)inputVideoFrame:(RtcVideoFrame *)videoFrame fromSource:(NSInteger)tag;

@end

/// 视频管线中的可输出节点，可以将自己生产或从其他源接受到的视频数据输出给 可输入节点
@protocol RTCVideoBufferOutput <NSObject>

/// 获取所有输出目标
@property (nonatomic, strong, readonly) NSArray<id<RTCVideoBufferInput>> *outputTargets;

/// 后续节点是否需要拷贝帧数据, 默认 NO
/// @discussion 节点对视频帧的输出可能会有缓存复用等机制，类似机制可能会使后续节点处理过程受到影响
@property (nonatomic, assign, readonly) BOOL needCopyBuffer;

/// 添加输出目标
/// @param input 可输入节点
- (void)addOutputTarget:(id<RTCVideoBufferInput>)input;

/// 移除已有的输出目标
/// @param input 可输入节点
- (void)removeOutputTarget:(id<RTCVideoBufferInput>)input;

/// 移除所有输出节点
- (void)removeAllOutputTargets;

/// 输出数据，通常实现为按照添加顺序依次输出给输出目标
- (void)outputVideoFrame:(RtcVideoFrame *)videoFrame;

/// 向下游节点发消息
- (void)sendMessage:(NSString *)message;

@end

@interface RTCVideoBufferOutput : NSObject<RTCVideoBufferOutput>
@end
 
/// 视频数据处理节点, 支持单路数据输入、多路数据输出
@interface RTCVideoBufferNode : RTCVideoBufferOutput<RTCVideoBufferInput>
@end

NS_ASSUME_NONNULL_END
