//
//  RTCScreenVideoCapturer.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/6/27.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCScreenVideoCapturer_h
#define RTCScreenVideoCapturer_h
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>
#import <BaiduRtcRoom/RTCMediaCaptureDefine.h>

@class RTCSettingContext;

NS_ASSUME_NONNULL_BEGIN

static const NSInteger kDefaultSystemScreenShareUserId = INT_MAX;

typedef NS_ENUM(NSInteger, RtcScreenCaptureType) {
    RtcScreenCaptureTypeNone,
    RtcScreenCaptureTypeInApp,
    RtcScreenCaptureTypeSystemExt,
    RtcScreenCaptureTypeSystemHost,
};

typedef NS_ENUM(int, RtcScreenCaptureErr) {
    RtcScreenCaptureErrNone,
    
    RtcScreenCaptureErrRtcUnavailable    = 1,
    RtcScreenCaptureErrRecordUnavailable,
    RtcScreenCaptureErrSystemVersionUnsupported,
    RtcScreenCaptureErrCaptureTypeUnknown,
    
    RtcScreenCaptureErrAlreadyCapturing,
};

typedef NS_ENUM(int, RtcScreenCaptureState) {
    
    /** empty state */
    RtcScreenCaptureStateNone,
    
    /**
     called system's capture methods or procedure, waiting for its callback.
     before callback, user may be prompted with UI to confirm recording.
     */
    RtcScreenCaptureStateStarting,
    
    /** system has returned starting result, receiving screen frames. */
    RtcScreenCaptureStateCapturing,
    
    /** called system's stopping capture methods, waiting for its callback. */
    RtcScreenCaptureStateStoppping,
};

@protocol RTCScreenVideoCapturer;

@protocol RTCScreenVideoCapturerDelegate <NSObject>

- (void)rtcScreenVideoCapturer:(id<RTCScreenVideoCapturer>)capturer didStartCompleted:(NSError * _Nullable)error;
- (void)rtcScreenVideoCapturer:(id<RTCScreenVideoCapturer>)capturer didStopped:(NSError * _Nullable)error;

@end

@protocol RTCScreenVideoCapturer <BaiduVideoCapturer>

@property (nonatomic, weak) id<RTCScreenVideoCapturerDelegate> delegate;

- (RtcScreenCaptureType)captureType;
- (RtcScreenCaptureState)captureState;
- (void)enableLog:(BOOL)enable;

- (void)updateScreenShareParams:(BRTCScreenShareParams *)params;

@end

@protocol RTCScreenAppCapturer <RTCScreenVideoCapturer>
@end

@protocol RTCScreenSystemHostCapturer <RTCScreenVideoCapturer>

- (void)setupSystemScreenShareAppGroup:(NSString *)appGtoup
                                 appID:(NSString *)appId
                                 token:(NSString *)token
                              roomName:(NSString *)roomName
                                userId:(NSInteger)userId
                         paramSettings:(RtcParameterSettings *)paramSettings
                              settings:(RTCSettingContext *)settings;

@end

NS_ASSUME_NONNULL_END

#endif /* RTCScreenVideoCapturer_h */
