//
//  BaiduRtcVideoProcessManager.h
//  BaiduRtcRoom
//
//  Created by v_liyingna on 9/2/22.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef BaiduRtcVideoProcessManager_h
#define BaiduRtcVideoProcessManager_h
#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#elif TARGET_OS_OSX
#import <AppKit/AppKit.h>
#endif
#import <CoreMedia/CoreMedia.h>
#import <CoreVideo/CoreVideo.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>


@class BRTCVideoRecordParam;

typedef NS_ENUM (NSInteger, BRTCWatermarkType) {
    BRTCWatermarkTypeImage,
    BRTCWatermarkTypeText,
    BRTCWatermarkTypeTime
};

@interface BRTCWatermarkParam : NSObject<NSCopying>

//水印类型：图片 文本 时间
@property (nonatomic, assign) BRTCWatermarkType watermarkType;
//水印位置
@property (nonatomic, assign) CGRect rect;
/*资源地址：
 image（固定资源图片（png） or 绝对目录文件路径），
 文本（静态字符串 字符长度有最大限制 50，可根据设置的w宽度，自动换行，居左对齐），
 时间 (默认如果不设置时，使用yyyy-MM-dd HH:mm:ss format，可配置 yyyy-MM-dd\nHH:mm:ss 其中增加\n来进行换行)
 */
@property (nonatomic, copy) NSString *watermarkResource;
//文字大小，默认 32px
@property (nonatomic, assign) CGFloat textSize;
#if TARGET_OS_IPHONE
//文字颜色 默认白色
@property (nonatomic, strong) UIColor *textColor;
//描边颜色 默认黑色
@property (nonatomic, strong) UIColor *strokeColor;
#elif TARGET_OS_OSX
//文字颜色 默认白色
@property (nonatomic, strong) NSColor *textColor;
//描边颜色 默认黑色
@property (nonatomic, strong) NSColor *strokeColor;
#endif
//描边宽度，默认 1.f
@property (nonatomic, assign) CGFloat strokeWidth;

@end

@interface BRTCWatermarkParams : NSObject<NSCopying>
@property (nonatomic, strong) NSArray<BRTCWatermarkParam *> *params;

@end

@interface BRTCVideoProcessConfig : NSObject<NSCopying>

@property (nonatomic, assign) CMVideoDimensions resolution;
@property (nonatomic, assign) int fps;

@end

@protocol BaiduRtcVideoProcessManagerListener, BaiduRtcVideoStreamMixBufferListener;

@protocol BaiduRtcVideoProcessManager <NSObject>

- (void)setupWithConfig:(BRTCVideoProcessConfig *)config;

/// 输出需要处理的视频数据
/// @param sampleBuffer 视频帧
- (void)processSampleBuffer:(CMSampleBufferRef)sampleBuffer;
/// 设置处理订阅
/// @param listener 订阅回调
- (void)setProcessListener:(id<BaiduRtcVideoProcessManagerListener>)listener;

#pragma mark - 水印

- (void)enableWatermark:(BOOL)enable watermarkParams:(BRTCWatermarkParams *)watermarkParams;
- (BOOL)watermarkEnabled;

#pragma mark - 视频混流

- (void)enableVideoStreamMix:(BOOL)enable videoParam:(BRTCVideoRecordParam *)videoParam;

- (void)setStreamMixBufferListener:(id<BaiduRtcVideoStreamMixBufferListener>)listener;

- (void)updateVideoFrame:(RtcVideoFrame *)videoFrame index:(NSUInteger)index;
- (void)updateVideoFrames:(NSArray<RtcVideoFrame *> *)videoFrames layouts:(NSArray<NSValue *> *)layouts;

@end


@protocol BaiduRtcVideoProcessManagerListener <NSObject>

- (void)brtcVideoProcessManager:(id<BaiduRtcVideoProcessManager>)manager processSampleBufferCompleted:(CMSampleBufferRef)sampleBuffer;

@end

@protocol BaiduRtcVideoStreamMixBufferListener <NSObject>

- (void)brtcVideoProcessManager:(id<BaiduRtcVideoProcessManager>)manager streamMixBufferCompleted:(CMSampleBufferRef)sampleBuffer;

@end


#endif /* BaiduRtcVideoProcessManager_h */
