//
//  BaiduRtcRoomApiAudioSession.h
//  BaiduRtcRoom
//
//  Created by Sun,Jian(ACU-T102) on 2020/1/7.
//  Copyright © 2020年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef BaiduRtcRoomApiAudioSession_h
#define BaiduRtcRoomApiAudioSession_h

#import <AVFoundation/AVFoundation.h>

@protocol BaiduRtcRoomApiAudioSessionDelegate <NSObject>
@optional
/** Called on a system notification thread when AVAudioSession starts an
 *  interruption event.
 */
- (void)onAudioSessionDidBeginInterruption;

/** Called on a system notification thread when AVAudioSession ends an
 *  interruption event.
 */
- (void)onAudioSessionDidEndInterruption;

#if TARGET_OS_IPHONE
/** Called on a system notification thread when AVAudioSession changes the
 *  route.
 */
- (void)onAudioSessionDidChangeRouteWithReason:(AVAudioSessionRouteChangeReason)reason
                     previousRoute:(AVAudioSessionRouteDescription *)previousRoute;
#endif

/** Called on a system notification thread when AVAudioSession media server
 *  terminates.
 */
- (void)onAudioSessionMediaServerTerminated;

/** Called on a system notification thread when AVAudioSession media server
 *  restarts.
 */
- (void)onAudioSessionMediaServerReset;

/** Called on a BaiduRTC thread when the audio device is notified to begin
 *  playback or recording.
 */
- (void)onAudioSessionDidStartPlayOrRecord;

/** Called on a BaiduRTC thread when the audio device is notified to stop
 *  playback or recording.
 */
- (void)onAudioSessionDidStopPlayOrRecord;

/** Called when the AVAudioSession output volume value changes. */
- (void)onAudioSessiondidChangeOutputVolume:(float)outputVolume;

/// 音频会话激活回调
/// @param active 是否激活
/// @param outError 返回错误
- (void)onAudioSessionExternalSetActive:(BOOL)active error:(NSError **)outError;

@end

#endif /* BaiduRtcRoomApiAudioSession_h */
