//
//  BaiduRtcBeautyManager.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/6/14.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef BaiduRtcBeautyManager_h
#define BaiduRtcBeautyManager_h
#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#elif TARGET_OS_OSX
#import <AppKit/AppKit.h>
#endif
#import <CoreMedia/CoreMedia.h>
#import <CoreVideo/CoreVideo.h>

NS_ASSUME_NONNULL_BEGIN

#pragma mark - Face Beauty

typedef NS_ENUM(NSUInteger, RtcBeautyFeatureType) {
    
    // 美白
    RtcBeautyFeatureType_WhiteLevel,
    // 磨皮
    RtcBeautyFeatureType_BlurLevel,
    // 红润
    RtcBeautyFeatureType_RedLevel,
    // 大眼
    RtcBeautyFeatureType_EnlargingLevel,
    // 瘦脸
    RtcBeautyFeatureType_ThinningLevel,

    /// 下巴，默认50%开始
    RtcBeautyFeatureType_ChinLevel,
    /// 脸宽
    RtcBeautyFeatureType_FacewidthLevel,
    /// 下颚角
    RtcBeautyFeatureType_MandibleandleLevel,
    /// 眼距
    RtcBeautyFeatureType_EyelengthLevel,
    /// 眼角
    RtcBeautyFeatureType_EyeangleLevel,
    /// 眉距
    RtcBeautyFeatureType_BrowlengthLevel,
    /// 嘴形
    RtcBeautyFeatureType_MouthwidthLevel,
    /// 脸长
    RtcBeautyFeatureType_ThreepartlengthLevel,
    /// 发际线
    RtcBeautyFeatureType_ToppartlengthLevel,
    /// 中庭
    RtcBeautyFeatureType_MediumpartlengthLevel,
    /// 下庭
    RtcBeautyFeatureType_BottompartlengthLevel,
    /// 鼻长 50% 开始调节
    RtcBeautyFeatureType_NoseLengthLevel,
    /// 鼻宽
    RtcBeautyFeatureType_NosebridgewidthLevel,
    /// 颧骨
    RtcBeautyFeatureType_CheekBoneLevel,
};

@interface RtcBeautyConfig : NSObject

/// 分辨率。必须设置。
@property (nonatomic, assign) CMVideoDimensions dimensions;
/// 横屏配置。横屏必须设置。
@property (nonatomic, assign) BOOL landscapeLeft;
/// 视频帧率。必须设置。
@property (nonatomic, assign) NSInteger frameRate;

@end

#pragma mark - Effect

@interface BRTCEffectParams : NSObject<NSCopying>

/// 特效资源地址
/// @discussion 传入资源 case 文件地址，内部加载对应 case bundle 文件实现如 背景分割 等特效
@property (nonatomic, copy) NSString *resourcePath;

/// 特效资源 Id
@property (nonatomic, copy) NSString *resourceId;

@end

#pragma mark - BaiduRtcBeautyManager

@protocol BaiduRtcBeautyProcessListener;

@protocol BaiduRtcBeautyManager <NSObject>

/// 整体美颜效果是否开启
- (BOOL)beautyEnabled;

/// 美颜效果处理必要的配置
/// @param config 配置项
- (void)setupWithConfig:(RtcBeautyConfig *)config;

/// 开关整体美颜效果
/// @discussion 该接口用于临时开关美颜效果，关闭前对美颜的设置不会丢失
- (void)setBeautyEnabled:(BOOL)enabled;
 
/// 美颜塑形等能力通用调参接口
- (void)setBeautyFeature:(RtcBeautyFeatureType)featureType value:(NSObject *)value;

/// 开关整体背景分割效果
/// @param enabled 是否开启
/// @param params 特效配置
- (void)setHumanSegEnabled:(BOOL)enabled effectParams:(BRTCEffectParams * _Nullable)params;

/// 输出需要处理的视频数据
/// @param sampleBuffer 视频帧
- (void)processSampleBuffer:(CMSampleBufferRef)sampleBuffer;

/// 设置处理订阅
/// @param listener 订阅回调
- (void)setProcessListener:(id<BaiduRtcBeautyProcessListener>)listener;

@end

@protocol BaiduRtcBeautyProcessListener <NSObject>

- (void)brtcBeautyManager:(id<BaiduRtcBeautyManager>)manager processSampleBufferCompleted:(CMSampleBufferRef)sampleBuffer;

@end

NS_ASSUME_NONNULL_END

#endif /* BaiduRtcBeautyManager_h */
