//
//  BaiduRtcAudioProcessManager.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/7/25.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef BaiduRtcAudioProcessManager_h
#define BaiduRtcAudioProcessManager_h
#import <CoreAudio/CoreAudioTypes.h>
#import <AudioToolbox/AudioToolbox.h>

@class BaiduRtcAudioProcessManager;

typedef NS_ENUM (NSInteger, RtcVoiceChangeType) {
    RtcVoiceChangeTypeOriginal = 0,        //原声
    RtcVoiceChangeTypeLuoli = 1,           //萝莉
    RtcVoiceChangeTypeDaShu = 2,           //大叔
    RtcVoiceChangeTypeZhengTai = 3,        //正太
    RtcVoiceChangeTypeFeiZai = 4,          //肥仔
    RtcVoiceChangeTypeKTV = 5,             //KTV
    RtcVoiceChangeTypeFo = 6,              //佛
    RtcVoiceChangeTypeSinging = 7          // K歌人声效果
};

typedef NS_ENUM(NSInteger, BRTCAudioMixingState)  {
    BRTCAudioMixingStatePlaying,
    BRTCAudioMixingStatePaused,
    BRTCAudioMixingStateStopped,
    BRTCAudioMixingStateError,
};

typedef NS_ENUM(NSInteger, BRTCAudioMixingErrorCode) {
    BRTCAudioMixingErrorCode_Success,
    
    BRTCAudioMixingErrorCode_NotStarted         = -1,
    BRTCAudioMixingErrorCode_AlreadyStarted     = 1000,
    BRTCAudioMixingErrorCode_NoParam,
    BRTCAudioMixingErrorCode_FilePathNil,
    
    BRTCAudioMixingErrorCode_AudioSourceFail    = 1100
};

@interface BRTCAudioMixingParams : NSObject<NSCopying>

/// 本地文件路径
@property (nonatomic, copy) NSString *filePath;

/// 是否只在本地播放音乐文件，YES 表示仅本地播放，NO 表示播放同时将音乐文件混音推流，默认 YES。
@property (nonatomic, assign) BOOL loopback;

/// 音乐文件播放次数，≥ 0 表示次数，-1 表示不限制，默认 -1。
@property (nonatomic, assign) NSInteger cycle;

@end

@protocol BaiduRtcAudioProcessDelegate <NSObject>

/// 混音状态变化
/// @param manager apm
/// @param state 混音状态
/// @param error 错误码
- (void)brtcAudioProcess:(BaiduRtcAudioProcessManager *)manager audioMixingStateChanged:(BRTCAudioMixingState)state error:(BRTCAudioMixingErrorCode)error;

@end

@protocol BaiduRtcAudioProcessManager <NSObject>

/// 设置音频处理回调代理
/// @param delegate 回调代理
- (void)setAudioProcessDelegate:(id<BaiduRtcAudioProcessDelegate>)delegate;

/// 音频效果处理必要的配置
/// @param format 音频配置
- (BOOL)setupWithFormat:(AudioStreamBasicDescription *)format audioComponentDescription:(AudioComponentDescription)acd;

/// 处理音频数据
/// @param inBuffer 输入数据
/// @param toBuffer 输出数据
- (void)processBuffer:(AudioBuffer *)inBuffer toBuffer:(AudioBuffer *)toBuffer;

#pragma mark - 变声

/// 开关整体变声音效
/// @param enabled 是否开启
/// @discussion 该接口用于临时开关变声音效，关闭前设置的变声效果类型不会丢失
- (void)setVoiceChangeEnabled:(BOOL)enabled;

/// 设置变声效果类型
/// @param type 效果类型
- (void)setVoiceChangeType:(RtcVoiceChangeType)type;

#pragma mark - 音乐文件

/// 开始音乐文件混音
/// @param params 音乐文件混音参数
/// @return 操作结果
/// @discussion 该方法将音乐文件和采集音频数据合成一路数据进行编码推流，远端用户不能控制是否接受
- (int)startAudioMixing:(BRTCAudioMixingParams *)params;

/// 暂停音乐文件播放混音
- (int)pauseAudioMixing;

/// 恢复音乐文件播放混音
- (int)resumeAudioMixing;

/// 停止音乐文件混音
/// @return 操作结果
- (int)stopAudioMixing;

@end

#endif /* BaiduRtcAudioProcessManager_h */
