//
//  BaiduChatAgentDefines.h
//
//  Created by Sun,Jian(ACU-T102) on 2024/1/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

typedef NSString *BaiduAIAgentWorkFlowType NS_TYPED_ENUM;

extern BaiduAIAgentWorkFlowType const BAIDU_AI_AGENT_WORK_FLOW_VOICE_CHAT;
extern BaiduAIAgentWorkFlowType const BAIDU_AI_AGENT_WORK_FLOW_VIDEO_CHAT;

typedef NSString *BaiduChatAgentRegionType NS_TYPED_ENUM;
/** 欧美 */
extern BaiduChatAgentRegionType const BAIDU_CHAT_AGENT_REGION_EUROPE_AMERICA;


@interface AgentEngineParams : NSObject

/** 服务器端接口下发 cid, token， 当前调试传入空即可 { "cid": 1, "token": "xxx-aa-bb" }*/
@property (nonatomic, copy) NSString *config;

/** appid */
@property (nonatomic, copy) NSString *appId;

/** 工作流类型，默认用VoiceChat */
@property (nonatomic, assign) NSString * workFlow;

/** 实例id  服务器端下发，当前调试默认即可 */
@property (nonatomic, assign) NSInteger instanceId;

/** 调试开关 */
@property (nonatomic, assign) BOOL verbose;

/** 允许SDK将日志通过 onAgentLogPrint: 方法抛出 */
@property (nonatomic, assign) BOOL enableLogCallback;

/**
 * 海外服务器配置，参考 BaiduChatAgentRegionType
 * @discussion 中国大陆使用不用填写。
 */
@property (nonatomic, copy) NSString *regionServer;

/** 智能互动服务地址 */
@property (nonatomic, copy) NSString *rtcServerUrl;

/** 授权 key */
@property (nonatomic, copy) NSString *licenseKey;

/** 用户 id */
@property (nonatomic, copy) NSString *userId;

/** 语音自动打断 */
@property (nonatomic, assign) BOOL enableVoiceInterrupt DEPRECATED_MSG_ATTRIBUTE("服务端判定");

/** 本地音频打断能量值 默认80 */
@property (nonatomic, assign) NSInteger userAudioLevelInterrupt DEPRECATED_MSG_ATTRIBUTE("服务端判定");

/** 是否使用外部音频进行采集和播放 */
@property (nonatomic, assign) BOOL enableExternalAudioDevice;

/**
 音频采样率
 @discussion 手动设置采样率存在与实际音频设备支持配置不符，导致采集播放异常的风险，请在明确知晓设备场景时进行设置，如外部采集
 */
@property (nonatomic, assign) int audioSampleRate;

/** 是否固定使用配置音频采样率，默认 YES */
@property (nonatomic, assign) BOOL useFixedSampleRate;

/**
 是否开启软件回声消除AEC
 @discussion 尽量使用默认的iOS系统硬件回声消除，应在明确知道应用环境中存在较长延迟时，才尝试开启该配置
 */
@property (nonatomic, assign) BOOL enableSoftwareAEC;

/** 软件回声消除等级, 默认 RtcAecLevelDefault */
@property (nonatomic, assign) RtcAecLevel softwareAECLevel;

/**
 是否 dump 录音数据
 @discussion 录制格式 pcm，每次 call hangup 形成一个录音文件，录制目录：Documents/audio_dump
 */
@property (nonatomic, assign) BOOL enableDumpAudioInput;
@property (nonatomic, assign) BOOL enableDumpAecAudio;

@end

/**
 ASR 附加信息
 */
@interface AgentAsrExtInfo : NSObject

/** 说话人标识 */
@property (nonatomic, copy) NSString *speakerName;

/** 声纹 置信度 */
@property (nonatomic, assign) int similarity;

/** 情感名称 */
@property (nonatomic, copy) NSString *emotion;

/** 标识当前句子id */
@property (nonatomic, assign) NSInteger sessionId;

@end
