//
//  BCALocationManager.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/20.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BCALocation : NSObject

@property (nonatomic, assign) int coordinateType; // 0 OriginalGPS; 1 BaiduMapSDK; 2 GCJ
@property (nonatomic, assign) CLLocationCoordinate2D coordinate; // 经纬度
@property (nonatomic, copy, nullable) NSString *province;
@property (nonatomic, copy, nullable) NSString *city;
@property (nonatomic, copy, nullable) NSString *district;
@property (nonatomic, copy, nullable) NSString *street;
@property (nonatomic, copy, nullable) NSString *name;
@property (nonatomic, copy, nullable) NSString *detailAddress;
@property (nonatomic, copy, nullable) NSString *locationDescription;
@property (nonatomic, strong, nullable) NSDate *timestamp; // 获取时间戳

- (instancetype)initWithLocation:(CLLocation *)location placemark:(CLPlacemark *)placemark;

@end

@protocol BCALocationManagerDelegate <NSObject>

@optional

- (void)locationManagerDidUpdateLocation:(BCALocation *)location;
- (void)locationManagerDidFailWithError:(NSError *)error;
- (void)locationManagerDidChangeAuthorizationStatus:(BOOL)authorized;

@end

@interface BCALocationManager : NSObject

@property (nonatomic, readonly) BCALocation *currentLocation; // 当前位置
@property (nonatomic, assign, readonly) BOOL isUpdatingLocation; // 是否正在更新位置
@property (nonatomic, assign) NSTimeInterval updateInterval; // 自动更新间隔（秒）

@property (nonatomic, readonly) CLAuthorizationStatus authorizationStatus;

@property (nonatomic, weak) id<BCALocationManagerDelegate> delegate;

// 请求位置权限（首次必须用户主动触发）
- (BOOL)requestLocationPermission;

// 开始更新位置（单次）
- (void)requestLocation;

- (void)startUpdatingLocation;
- (void)stopUpdatingLocation;

- (void)startUpdatingHeading;
- (void)stopUpdatingHeading;

@end

NS_ASSUME_NONNULL_END
