//
//  RTCTextField.h
//  RtcBoxApp
//
//  Created by 曹士谦 on 2024/3/19.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>

static CGFloat const kRoomTextFieldHeight = 40;
static CGFloat const kRoomTextFieldMargin = 8;

@class RTCTextField;

@protocol NoticeextFieldSaveDelegate <NSObject>

- (void)onNoticeSave:(RTCTextField *) textField;

@end

@interface RTCTextField : UIView<UITextFieldDelegate>

@property(copy, nonatomic) NSString *roomText;
@property (nonatomic, weak) id<NoticeextFieldSaveDelegate> delegate;

- (instancetype)initWithFrame:(CGRect)frame 
                     delegate:(id<NoticeextFieldSaveDelegate>)noticeFieldDelegate
                         back:(NSString *) context;

- (void)setPlaceHolder:(NSString *)ph;

@end
