//
//  MainView.h
//  ChatAgentApp
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef MainView_h
#define MainView_h
#import <UIKit/UIKit.h>

@class MainView;

@protocol MainViewDelegate <NSObject>

- (void)mainView:(MainView *)mainView 
         didCall:(NSString *)channelId
          config:(NSString *)param
             app:(NSString *)appId
            user:(NSString *)userId
             hd:(BOOL)env;

@end

// The main view of AppRTCMobile. It contains an input field for entering a room
// name on apprtc to connect to.
@interface MainView : UIView

@property(nonatomic, weak) id<MainViewDelegate> delegate;

@property (nonatomic, assign, readonly) BOOL enableExternalAudio;
@property (nonatomic, copy, readonly) NSString *licenseKey;

@end

#endif /* RTCMainView_h */
