//
//
//  AIChatAgentController.h
//  ChatAgentApp
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BaseViewController.h"

@interface MineController

@end
@class ChatViewController;
@class AgentEngineParams;

NS_ASSUME_NONNULL_BEGIN
@protocol AIChatAgentControllerDelegate <NSObject>

- (void)viewControllerDidFinish:(ChatViewController *)viewController;

@end

@interface AIChatAgentController : BaseViewController
<
UITableViewDelegate,
UITableViewDataSource
>

@property (nonatomic, assign) BOOL enableExternalAudio;
@property (nonatomic, assign) BOOL enableDumpAudioInput;

- (instancetype)initWithParams:(id<AIChatAgentControllerDelegate>)delegate 
                          conf:(NSString *)param 
                           app:(NSString *)appID
                          user:(NSString *)userId
                            hd:(BOOL)isHD;

@property UITableView *tableView;
@property NSMutableArray *messageRole; // role 1 agent  2 client
@property (nonatomic) NSNumber *rowHeight;
@property NSMutableArray *rowHeightArr;

@end

NS_ASSUME_NONNULL_END
