//
//  BCAPoiSearchTask.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/21.
//

#import <Foundation/Foundation.h>
#import "BCALocationManager.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BCAPoiSearchError) {
    BCAPoiSearchErrorNone,
    BCAPoiSearchErrorCallFail,
    BCAPoiSearchErrorSearchFail,
};

typedef void(^BCAPoiSearchCompletionBlock)(NSArray<BCALocation *> * _Nullable results, NSError * _Nullable error);

@interface BCAPoiSearchTask : NSObject

@property (nonatomic, assign) int searchErrorCode;

/**
 * 初始化搜索任务
 * @param locations 需要搜索的位置数组
 * @param completion 完成回调，返回结果数组（与locations顺序一致）
 */
- (instancetype)initWithLocations:(NSArray<BCALocation *> *)locations
                  currentLocation:(BCALocation *)currentLocation
                       completion:(BCAPoiSearchCompletionBlock)completion;

- (void)start;
- (void)cancel;

@end

NS_ASSUME_NONNULL_END
