//
//  BMRouteReusableView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/15.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "RouteReusableView.h"
#import "MapCommonDefine.h"

@implementation RouteSupplementaryIconView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _imageView = [[UIImageView alloc] initWithFrame:self.bounds];
        [self addSubview:_imageView];
        
        _imageView.autoresizingMask = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
        
        self.layer.cornerRadius = 10;
    }
    
    return self;
}

@end


@implementation RouteSupplementaryLineView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _line = [[UIView alloc] initWithFrame:self.bounds];
        _line.userInteractionEnabled = NO;
        [self addSubview:_line];
        
        _line.autoresizingMask = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
    }
    
    return self;
}

@end


@implementation RouteSupplementaryDashedLineView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        self.backgroundColor = [UIColor clearColor];
        self.clipsToBounds = YES;
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        [shapeLayer setBounds:self.bounds];
        [shapeLayer setPosition:CGPointMake(frame.size.width/2, frame.size.height/2)];
        [shapeLayer setFillColor:[[UIColor clearColor] CGColor]];
        [shapeLayer setStrokeColor:[UIColorFromRGB(0xdddddd) CGColor]];
        [shapeLayer setLineWidth:1.0f];
        [shapeLayer setLineJoin:kCALineJoinRound];
        [shapeLayer setLineDashPattern:
         [NSArray arrayWithObjects:[NSNumber numberWithInt:3],
          [NSNumber numberWithInt:2],nil]];
        
        // Setup the path
        CGMutablePathRef path = CGPathCreateMutable();
        CGPathMoveToPoint(path, NULL, frame.size.width/2, 0);
        CGPathAddLineToPoint(path, NULL, frame.size.width/2, frame.size.height);
        
        [shapeLayer setPath:path];
        CGPathRelease(path);
        
        [self.layer addSublayer:shapeLayer];
    }
    
    return self;
}

@end


@implementation RouteCollectionViewCell

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        
        _titleLabel = [[UILabel alloc] initWithFrame:self.bounds];
        [self.contentView addSubview:_titleLabel];
        _titleLabel.numberOfLines = 0;
        _titleLabel.lineBreakMode = NSLineBreakByCharWrapping;
        
        _titleLabel.frame = CGRectMake(82, 0, _titleLabel.superview.width - 84, _titleLabel.superview.height);
        
        UIView *bgView = [[UIView alloc] init];
        bgView.backgroundColor = [UIColor clearColor]; // UIColorFromRGB(0xf5f5f5)
        self.selectedBackgroundView = bgView;
    }
    
    return self;
}

@end
