//
//  RadarLocationView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/21.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "RadarLocationView.h"
#import "UIImage+Ext.h"
#import "MapCommonDefine.h"

@interface RadarLocationView ()

@property (nonatomic, strong) UIButton *radarButton;

@end

@implementation RadarLocationView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initUI];
    }
    return self;
}

- (void)initUI {
    self.backgroundColor = [UIColor whiteColor];
    
    self.radarButton = [UIButton buttonWithType:UIButtonTypeCustom];
    self.radarButton.frame = self.bounds;
    [self.radarButton setBackgroundImage:[UIImage imageWithColor:[UIColor whiteColor]] forState:UIControlStateHighlighted];
    [self.radarButton setBackgroundImage:[UIImage imageWithColor:[UIColor lightGrayColor]] forState:UIControlStateHighlighted];
    self.radarButton.exclusiveTouch = YES;
    self.radarButton.layer.masksToBounds = YES;
    self.radarButton.layer.cornerRadius = ADAPTOR_VALUE_1242(20);
    [self.radarButton setImage:[UIImage imageNamed:@"icon_radar_location"] forState:UIControlStateNormal];
    [self.radarButton addTarget:self action:@selector(radarLocButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.radarButton];
}

- (void)radarLocButtonClick:(UIButton *)btn {
    if (self.delegate && [self.delegate respondsToSelector:@selector(radarLocation:)]) {
        [self.delegate radarLocation:self];
    }
}

@end
