//
//  RouteDataHelper.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "RouteDataHelper.h"

@implementation RouteDataHelper

+ (NSString *)distanceStringFromMeters:(NSInteger)distance {
    NSString *stringTips = nil;
    if (distance > 1000) {
        float disF = distance / 1000.0;
        if(distance /1000.0 > 10) {
            int intdisF = disF + 0.5;
            stringTips = [NSString stringWithFormat:@"%d%@", intdisF, @"公里"];
        } else {
            stringTips = [NSString stringWithFormat:@"%.1f%@", disF, @"公里"];
        }
    } else {
        if(distance == 0) {
            distance = 1;
        }
        stringTips = [NSString stringWithFormat:@"%d%@", (int)distance, @"米"];
    }
    return stringTips;
}

+ (NSString *)seconds2HourAndMinDescription:(NSUInteger)seconds {
    if (seconds < 60) {
        return @"1分钟";
    }
#define SECONDS_OF_HOUR       (3600)
#define SECONDS_OF_HALF_HOUR  (1800)
#define SECONDS_OF_DAY        (86400)
    unsigned long hour = seconds / SECONDS_OF_HOUR;
    seconds %= SECONDS_OF_HOUR;
    unsigned long minute =  seconds / 60;
    
    NSString *description = [NSString stringWithFormat:@""];
    if (hour != 0) {
        description = [description stringByAppendingString:[NSString stringWithFormat:@"%ld小时",hour]];
    }
    
    if (minute != 0) {
        if (hour != 0) {
            description = [description stringByAppendingString:[NSString stringWithFormat:@"%ld分",minute]];
        } else {
            description = [description stringByAppendingString:[NSString stringWithFormat:@"%ld分钟",minute]];
        }
    }
    return description;
}

+ (NSString *)getCarPageTimeDescription:(NSInteger)time {
    return [RouteDataHelper seconds2HourAndMinDescription:time];
}

+ (NSString *)getCarPageDistanceDescription:(NSInteger)distance {
    return [RouteDataHelper distanceStringFromMeters:distance];
}

@end
