//
//  BNaviUtil.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/22.
//

#import "BNaviUtil.h"

@interface BNaviUtil ()<BMKGeneralDelegate>

@property (nonatomic, weak) id<BNNaviSoundDelegate> soundDelegate;
@property (nonatomic, strong) BMKMapManager *mapManager;
@property (atomic, assign) BNaviInitState mapInitState;
@property (atomic, assign) BNaviInitState naviInitState;

@end

@implementation BNaviUtil

static BNaviUtil *_instance = nil;
static BMKMapManager *_mapManager = nil;

+ (instancetype)sharedInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _instance = [[BNaviUtil alloc] init];
    });
    return _instance;
}

- (void)initMap {
    if (self.mapInitState == BNaviInitStateNotInit || self.mapInitState == BNaviInitStateInitFailed) {
        BOOL ret = [self initMapSDK];
        if (!ret) {
            self.mapInitState = BNaviInitStateInitFailed;
            return;
        }
        self.mapInitState = BNaviInitStateIniting;
    }
}

- (void)initNavi {
    if (self.naviInitState == BNaviInitStateNotInit || self.naviInitState == BNaviInitStateInitFailed) {
        [self initNaviSDK];
        self.naviInitState = BNaviInitStateIniting;
    }
}

- (void)setSoundDelegate:(id<BNNaviSoundDelegate>)delegate {
    _soundDelegate = delegate;
    if (self.naviInitState == BNaviInitStateInited) {
        [BNaviService_Sound setSoundDelegate:delegate];
    }
}

- (void)setAlwaysUpdatingLocation:(BOOL)alwaysUpdatingLocation {
    [BNaviService_Location setAlwaysUpdatingLocation:alwaysUpdatingLocation];
}

#pragma mark - Private

- (BOOL)initMapSDK {
    // 地图SDK 隐私权限（业务按需添加独立的隐私授权流程）
    [BMKMapManager setAgreePrivacy:YES];
    // 地图SDK 初始化鉴权
    BMKMapManager *mapManager = [[BMKMapManager alloc] init];
    self.mapManager = mapManager;
    // 如果要关注网络及授权验证事件，请设定generalDelegate参数
    BOOL ret = [self.mapManager start:BNAVI_APP_KEY generalDelegate:self];
    if (!ret) {
        NSLog(@"[map] initMapSDK fail");
    }
    return ret;
}

- (void)initNaviSDK {
    // 导航SDK 隐私权限（业务按需添加独立的隐私授权流程）
    [BNaviService setAgreePrivacy:YES];
    // 导航SDK 初始化鉴权
    __weak typeof(self) weakSelf = self;
    [BNaviService_Instance initNaviService:nil success:^{
        BNaviService_Strategy.yawSpecifiedRouteNavigation = 1;
        [BNaviService_Instance authorizeNaviAppKey:BNAVI_APP_KEY
                                        completion:^(BOOL suc) {
                                            NSLog(@"authorizeNaviAppKey ret = %d", suc);
                                        }];
        // 使用 ChatAgent TTS
//        [BNaviService_Instance authorizeTTSAppId:TTS_APP_ID
//                                          apiKey:TTS_API_KEY
//                                       secretKey:TTS_SECRET_KEY
//                                      completion:^(BOOL suc) {
//                                          NSLog(@"authorizeTTS ret = %d",suc);
//                                      }];
//        [BNaviService_Strategy setUseSystemTTS:YES];
        [BNaviService_Sound setSoundDelegate:weakSelf.soundDelegate];
        NSLog(@"[map] initNaviSDK succ cuid = %@", [BNUtility getLBSCuid]);
        weakSelf.naviInitState = BNaviInitStateInited;
    } fail:^{
        NSLog(@"[map] initNaviSDK fail");
        weakSelf.naviInitState = BNaviInitStateInitFailed;
    }];
}

#pragma mark - BMKGeneralDelegate

- (void)onGetNetworkState:(int)iError {
    if (0 == iError) {
        NSLog(@"[map] 联网成功");
    } else {
        NSLog(@"[map] 联网失败：%d", iError);
    }
}

- (void)onGetPermissionState:(int)iError {
    // BMKPermissionCheckResultCode
    if (0 == iError) {
        NSLog(@"[map] initMapSDK succ");
        self.mapInitState = BNaviInitStateInited;
    } else {
        NSLog(@"[map] initMapSDK fail: %d", iError);
        self.mapInitState = BNaviInitStateInitFailed;
    }
}

@end
