//
//  BCAMapNavigateCardView.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/24.
//

#import "BCAMapNavigateCardView.h"
#import "BNCarRouteData.h"

static CGFloat kPadding = 10.f;
static CGFloat kMargin = 5.f;
static CGFloat kLabelHeight = 20.f;

@interface BCAMapNavigateCardView ()

@property (nonatomic, strong) UILabel *naviLabel;
@property (nonatomic, strong) UILabel *distanceLabel;
@property (nonatomic, strong) UILabel *timeLabel;
@property (nonatomic, strong) UILabel *routeNameLabel;
@property (nonatomic, strong) UIView *separatorLine;

@end

@implementation BCAMapNavigateCardView

- (void)setupViews {
    [super setupViews];
    
    // 路线标签
    self.naviLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    [self addSubview:self.naviLabel];
    
    // 分隔线
    self.separatorLine = [[UIView alloc] init];
    self.separatorLine.backgroundColor = [UIColor lightGrayColor];
    [self addSubview:self.separatorLine];
    
    // 路线名称标签
    self.routeNameLabel = [self labelWithFont:16.f color:[UIColor systemBlueColor]];
    [self addSubview:self.routeNameLabel];
    
    // 距离标签
    self.distanceLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    [self addSubview:self.distanceLabel];
    
    // 时间标签
    self.timeLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    [self addSubview:self.timeLabel];
}

- (CGSize)boundingRectWithSize:(CGSize)size {
    CGFloat height = [self cardHeight];
    return CGSizeMake(size.width, height);
}

// 计算卡片总高度
- (CGFloat)cardHeight {
    CGFloat topHeight = kLabelHeight;
    CGFloat separateHeight = kMargin * 2 + 1.0;
    CGFloat bottomHeight = kLabelHeight + kMargin + kLabelHeight;
    return kPadding * 2 + topHeight + separateHeight + bottomHeight;
}

- (void)updateWithCarRoute:(BNCarRouteModel *)route {
    if (!route || route.carRoutes.count == 0) {
        return;
    }
    
    // 获取第一条路线信息
    BNCarOneRouteModel *firstRoute = route.carRoutes.firstObject;
    
    // 设置起点和终点
    NSMutableString *naviText = [NSMutableString string];
    [naviText appendString:(firstRoute.startPoint.name ?: @"我的位置")];
    [naviText appendString:@" -> "];
    [naviText appendString:firstRoute.endPoint.name];
    self.naviLabel.text = naviText;
    
    // 设置路线名称
    self.routeNameLabel.text = firstRoute.routeLabelName ?: @"推荐路线";
    
    // 设置距离信息
    if (firstRoute.distance > 1000) {
        self.distanceLabel.text = [NSString stringWithFormat:@"%.1f公里", firstRoute.distance / 1000.0];
    } else {
        self.distanceLabel.text = [NSString stringWithFormat:@"%ld米", (long)firstRoute.distance];
    }
    
    // 设置时间信息
    NSInteger hours = firstRoute.time / 3600;
    NSInteger minutes = (firstRoute.time % 3600) / 60;
    
    if (hours > 0) {
        self.timeLabel.text = [NSString stringWithFormat:@"%ld小时%ld分钟", (long)hours, (long)minutes];
    } else {
        self.timeLabel.text = [NSString stringWithFormat:@"%ld分钟", (long)minutes];
    }
    
    [self setNeedsLayout];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    self.naviLabel.frame = CGRectMake(kPadding, kPadding, self.bounds.size.width - 2 * kPadding, kLabelHeight);
    self.separatorLine.frame = CGRectMake(kPadding, CGRectGetMaxY(self.naviLabel.frame) + kMargin, self.bounds.size.width - 2 * kPadding, 1);
    self.routeNameLabel.frame = CGRectMake(kPadding, CGRectGetMaxY(self.separatorLine.frame) + kMargin, 100, kLabelHeight);
    self.distanceLabel.frame = CGRectMake(kPadding, CGRectGetMaxY(self.routeNameLabel.frame) + kMargin, 100, kLabelHeight);
    self.timeLabel.frame = CGRectMake(CGRectGetMaxX(self.distanceLabel.frame) + 10, CGRectGetMaxY(self.routeNameLabel.frame) + kMargin, 100, kLabelHeight);
}

- (UILabel *)labelWithFont:(CGFloat)font color:(UIColor *)color {
    UILabel *label = [[UILabel alloc] init];
    label.font = [UIFont systemFontOfSize:16.0];
    label.textColor = color;
    return label;
}

@end
