//
//  BCAAudioRingBuffer.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/8/27.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BCAAudioRingBuffer : NSObject

@property (nonatomic, assign, readonly) size_t capacity;
@property (nonatomic, assign, readonly) size_t bytesAvailable;
@property (nonatomic, assign, readonly) size_t spaceAvailable;

- (instancetype)initWithCapacity:(size_t)capacity;
- (void)dealloc;

- (size_t)write:(const void *)data length:(size_t)length;
- (size_t)read:(void *)data length:(size_t)length;
- (size_t)peek:(void *)data length:(size_t)length;
- (void)clear;

@end

NS_ASSUME_NONNULL_END
