//
//  BCAAudioExternalDevice.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/8/27.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>
#import <BaiduChatAgent/BaiduChatAgent.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, BCAAudioDeviceType) {
    BCAAudioDeviceTypeRecord,
    BCAAudioDeviceTypePlayer
};

@interface BCAAudioExternalDeviceImpl : NSObject<BaiduRtcRoomApiAudioExternalRecordDevice, BaiduRtcRoomApiAudioExternalPlayerDevice>

@property (nonatomic, assign) BCAAudioDeviceType deviceType;

- (instancetype)initWithType:(BCAAudioDeviceType)type;

@end

@interface BCAAudioExternalDevice : NSObject<BaiduRtcRoomApiAudioExternalDeviceDelegate>

@end

NS_ASSUME_NONNULL_END
