//
//
//  BaiduAgentApi.h
//  ChatAgentApp
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//
#import <Foundation/Foundation.h>
#import "BDCloudRTCBaseDefine.pch"

@interface BaiduAgentApiStartRequest : NSObject
@property (nonatomic, copy) NSString *appId;
@property (nonatomic, assign) BOOL quicStart;
@property (nonatomic, copy) NSString *config;
@end

@interface BaiduAgentApiStartResponse : NSObject
@property (nonatomic, assign) NSInteger instanceId;
@property (nonatomic, copy) NSString *token;
@property (nonatomic, copy) NSString *context;
@end


@interface BaiduAgentApiStopRequest : NSObject
@property (nonatomic, copy) NSString *appId;
@property (nonatomic, assign) NSInteger instanceId;
@end

@interface BaiduAgentApiStopResponse : NSObject
@end

@protocol BaiduAgentApiEventDelegate <NSObject>
- (void)baiduAgentApiConnectFailed:(NSString *)reason;
@end

@interface BaiduAgentApi : NSObject
#ifndef APP_FOR_TAL
+ (NSString *) configBuild:(NSString *)env model:(NSString *)nIndex tts:(NSString *)tts asr:(NSString *)asr;
#else
+ (NSString *) configBuild:(NSString *)env model:(NSString *)model llmurl:(NSString *)llm_url tts:(NSString *)ttsSay;
#endif

+ (NSString *)getRegionServer;

- (instancetype)initWithParams:(NSString *)config delegate:(id<BaiduAgentApiEventDelegate>)delegate;

- (void)sendStartRequest:(BaiduAgentApiStartRequest *) params block:(void (^)(BaiduAgentApiStartResponse *)) block;

- (void)sendStopRequest:(BaiduAgentApiStopRequest *)params block:(void (^)(BaiduAgentApiStopResponse *)) block;
@end
