//
//  AIChatInputBar.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/7/4.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

#define kInputBarHeight 50.0
#define kSafeAreaBottom 44.f
#define kMediaPanelHeight 100.0

typedef NS_ENUM(NSInteger, BUTTON_TAG) {
    BUTTON_TAG_SEND = 100,
    BUTTON_TAG_ADD,
    BUTTON_TAG_QUIT,
    BUTTON_TAG_PAUSE,
    BUTTON_TAG_CAMERA,
    BUTTON_TAG_PHOTO,
};

@protocol AIChatInputBarDelegate <NSObject>

- (void)inputBarActionWithTag:(BUTTON_TAG)tag;
- (void)inputBarDidSendText:(NSString *)text;

@end

@interface AIChatInputBar : UIView

@property (nonatomic, weak) id<AIChatInputBarDelegate> delegate;

@property (nonatomic, assign, readonly) BOOL isKeyboardShow;

@property (nonatomic, strong) UITextField *textField;

- (void)showMediaPanel;
- (void)hideMediaPanel;

@end

NS_ASSUME_NONNULL_END
