//
//  AIChatCameraPreviewView.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/7/7.
//

#import "AIChatCameraPreviewView.h"
#import <BaiduRtcRoom/RTCLocalVideoView.h>

#define W ([UIScreen mainScreen].bounds.size.width)
#define H ([UIScreen mainScreen].bounds.size.height)

#define kSafeAreaBottom 44.f

static CGFloat const kBottomPaneHeight = 100;
static CGFloat const kBottomButtonSize = 60.f;

@interface AIChatCameraPreviewView ()

@property (nonatomic, strong) RTCLocalVideoView *rtcVideoView;

@property (nonatomic, strong) UIView *bottomPane;
@property (nonatomic, strong) UIButton *closeButton;
@property (nonatomic, strong) UIButton *switchButton;

@end

@implementation AIChatCameraPreviewView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setupSubviews];
    }
    return self;
}

- (void)setupSubviews {
    self.backgroundColor = [UIColor colorWithWhite:0.9 alpha:1.0];
    
    self.rtcVideoView = [[RTCLocalVideoView alloc] initWithDelegate:nil];
    self.rtcVideoView.videoView.videoGravity = AVLayerVideoGravityResizeAspectFill;
    [self addSubview:self.rtcVideoView.videoView];
    
    self.bottomPane = [[UIView alloc] initWithFrame:CGRectZero];
    [self addSubview:self.bottomPane];
    
    self.closeButton = [self buttonWithTag:100 imageName:@"btn_camera_close.png" frame:CGRectZero];
    self.switchButton = [self buttonWithTag:101 imageName:@"btn_camera_switch.png" frame:CGRectZero];
    [self.bottomPane addSubview:self.closeButton];
    [self.bottomPane addSubview:self.switchButton];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat height = kBottomPaneHeight + kSafeAreaBottom;
    self.bottomPane.frame = CGRectMake(0, H - height, W, height);
    
    self.rtcVideoView.videoView.frame = CGRectMake(0, 0, W, H - height);
    
    CGFloat marginH = (W / 2 - kBottomButtonSize) / 2;
    CGFloat marginV = (kBottomPaneHeight - kBottomButtonSize) / 2;
    self.closeButton.frame = CGRectMake(marginH, marginV, kBottomButtonSize, kBottomButtonSize);
    self.switchButton.frame = CGRectMake(W / 2 + marginH, marginV, kBottomButtonSize, kBottomButtonSize);
}

- (void)buttonAction:(UIButton *)sender {
    if (sender.tag == 100) {
        if ([self.delegate respondsToSelector:@selector(cameraPreviewTriggerClose)]) {
            [self.delegate cameraPreviewTriggerClose];
        }
        return;
    }
    
    if (sender.tag == 101) {
        if ([self.delegate respondsToSelector:@selector(cameraPreviewTriggerSwitchCamera)]) {
            [self.delegate cameraPreviewTriggerSwitchCamera];
        }
        return;
    }
}

#pragma mark - UI

- (UIButton *)buttonWithTag:(NSInteger)tag imageName:(NSString *)imageName frame:(CGRect)frame {
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = frame;
    [btn setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(buttonAction:) forControlEvents:UIControlEventTouchUpInside];
    btn.tag = tag;
    return btn;
}

- (CGFloat)safeAreaBottom {
    CGFloat safeAreaBottom = 0.f;
    if (@available(iOS 11.0, *)) {
        safeAreaBottom = kSafeAreaBottom;
    }
    return safeAreaBottom;
}

@end
