//
//  RTCMediaCaptureDefine.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/5/20.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCMediaCaptureDefine_h
#define RTCMediaCaptureDefine_h
#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#endif
#import <CoreMedia/CoreMedia.h>
#import <CoreVideo/CoreVideo.h>
#import <BaiduRtcRoom/RTCVideoBufferNode.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

NS_ASSUME_NONNULL_BEGIN

#pragma mark - Capturer Delegate

@protocol BaiduMediaCapturerDelegate <NSObject>
@end

@protocol BaiduAudioCapturerDelegate <BaiduMediaCapturerDelegate>
@end

@protocol BaiduVideoCapturer;

/// 视频数据处理回调
@protocol BaiduVideoCapturerDelegate <BaiduMediaCapturerDelegate>

/// 提供为采集后续阶段设置编码配置的能力
/// @param capturer 采集器
/// @param width 视频宽度
/// @param height 视频高度
/// @param fps 视频帧率
- (void)capturer:(id<BaiduVideoCapturer>)capturer didChangeOutputFormatToWidth:(int)width height:(int)height fps:(int)fps;

/// 采集器输出方向发生变化
/// @param capturer 采集器
/// @param rotation 方向
- (void)capturer:(id<BaiduVideoCapturer>)capturer didUpdateRotation:(BaiduVideoRotation)rotation;

/// 采集器输出媒体数据
/// @param capturer 采集器
/// @param videoFrame 视频帧
- (void)capturer:(id<BaiduVideoCapturer>)capturer didCaptureVideoFrame:(RtcVideoFrame *)videoFrame;

@end

#pragma mark - Capturer

@protocol BaiduCameraController;

/// 媒体数据采集器协议，BRTC 内部已经实现对 Camera、File 的视频采集，
/// 接入方可通过实现该协议实现自定义数据采集能力
@protocol BaiduMediaCapturer <NSObject>
 
/// 用于接收采集器输出数据的回调代理创建完毕
/// @param captureDelegate 采集数据回调
/// @discussion 自定义采集需要在该方法中完成对采集回调的持有，以实现向 BRTC 输入自定义采集数据
- (void)didCreateCaptureDelegate:(id<BaiduMediaCapturerDelegate> _Nonnull)captureDelegate;
 
/// 开始采集
- (void)startCapture;
 
/// 停止采集
- (void)stopCapture;
 
@end

@protocol BaiduVideoCapturer <BaiduMediaCapturer>

/// 输出帧率
@property (nonatomic, assign) int fps;

/// 输出尺寸
@property (nonatomic, assign) CGSize resolution;

/// 输出强制裁剪尺寸
@property (nonatomic, assign) CGSize outputCropSize;

@end

#pragma mark - Media Device Control

/// 系统相机控制器协议
@protocol BaiduCameraController <NSObject>

/// 是否允许根据设备方向自动更新采集输出方向，默认为 YES
@property (nonatomic, assign) BOOL enableAutoUpdateOrientation;
#if TARGET_OS_IPHONE
/// 相机采集默认输出方向，默认为 UIDeviceOrientationPortrait
@property (nonatomic, assign) UIDeviceOrientation outputOrientation;
#endif
/// 启停采集
- (void)startCamera;
- (void)stopCamera;
 
/// 切换前后摄像头，默认为 YES
- (void)switchCamera;
- (void)setCameraPosition:(BOOL)isFront;
- (BOOL)usingFrontCamera;
 
/// 对焦
- (void)setCameraFocusPoint:(CGPoint)point;
 
/// 曝光
- (void)setCameraExposurePoint:(CGPoint)point;
 
/// 开关手电筒
- (void)setTorchOn:(BOOL)isOn;
 
/// 视频镜像
- (void)setOutputVideoMirrored:(BOOL)isMirrored;
 
@end

NS_ASSUME_NONNULL_END

#endif /* RTCMediaCaptureDefine_h */
