//
//  BaiduRtcRoomApiDefines.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/5.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef BaiduRtcRoomApiDefines_h
#define BaiduRtcRoomApiDefines_h
#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>
#import <CoreVideo/CoreVideo.h>

#define BRTC_DEPRECATED(message) __attribute__((deprecated(message)))

#define BRTC_SYMBOL_CONCAT_HELPER(a, b) a##b
#define BRTC_SYMBOL_CONCAT(a, b) BRTC_SYMBOL_CONCAT_HELPER(a, b)

#define BRTC_TYPE_PREFIX BaiduRtc

#define BRTC_TYPE(type_name) BRTC_SYMBOL_CONCAT(BRTC_TYPE_PREFIX, type_name)

/** 标识房间内用户状态 */
@interface RtcRoomUserInfo : NSObject<NSCopying>
/** 用户 ID */
@property (nonatomic, copy) NSNumber *userID;
/** 用户名 */
@property (nonatomic, copy) NSString *userName;
/** 属性 */
@property (nonatomic, copy) NSString *attribute;
/** 角色 */
@property (nonatomic, assign) int role;
/** true 远端状态，本地永远是true 可以推流状态 用于列表中是否可拉流判断*/
@property (nonatomic, assign) bool remotePushing;
/** 是否是远端用户*/
@property (nonatomic, assign) bool remote;
/** true 订阅中  本地推流中; false 未拉流  未推流 */
@property (nonatomic, assign) bool streaming;
/** true 拉视频，推视频   */
@property (nonatomic, assign) bool video;
/** true 拉音频  推音频*/
@property (nonatomic, assign) bool audio;

@end

/**
 文本消息结构
 */
@interface RtcMessageInfo : NSObject
/**
 userId, 文本消息的归属者
 */
@property (nonatomic, copy) NSNumber *userId;

/**
 消息类型
 */
@property (nonatomic, assign) int type;

/**
 具体的文本消息
 */
@property (nonatomic, copy) NSString *message;
@end


/** 用户语音激励 */
@interface RtcRoomAudioLevel : NSObject
/** 用户 ID */
@property (nonatomic, copy) NSNumber *userID;
/** 用户名 */
@property (nonatomic, copy) NSString *userName;
/** 音量 */
@property (nonatomic, assign) NSInteger volumeLevel;
@end

/** 视频旋转方向 */
typedef NS_ENUM(NSUInteger, BaiduVideoRotation) {
    BaiduVideoRotation_0 = 0,
    BaiduVideoRotation_90 = 90,
    BaiduVideoRotation_180 = 180,
    BaiduVideoRotation_270 = 270,
};

typedef NS_ENUM(NSInteger, RtcDemoteType) {
    DEMOTE_NONE = 0,
    DEMOTE_AUDIO,
    DEMOTE_SRC_VIDEO,
};

/**
  * 链接状态变化
 */
typedef NS_ENUM(NSInteger, RtcConnectionState) {
    RTC_CONNECTION_STATE_DISCONNECTED = 1,
    RTC_CONNECTION_STATE_CONNECTING,
    RTC_CONNECTION_STATE_CONNECTED,
    RTC_CONNECTION_STATE_RECONNECTING,
};

/**
  * 链接状态变化原因标记
 */
typedef NS_ENUM(NSInteger, RtcConnectionChange) {
    CONNECTION_CHANGED_ACK_TIMEOUT = 1,
    CONNECTION_CHANGED_KEEPALIVE_TIMEOUT,
    CONNECTION_CHANGED_ICE_BREAK,
    CONNECTION_CHANGED_ICE_FAIL,
    CONNECTION_CHANGED_CHANNEL_BREAK,
    CONNECTION_CHANGED_BY_NETWORK,
    CONNECTION_CHANGED_BY_USER_ALREADY_EXIST,
    CONNECTION_CHANGED_BY_HANGUP,
};
/** 媒体链路状态 */
typedef NS_ENUM(NSInteger, RtcMediaStreamState) {
    RTC_MEDIA_STREAM_INIT_STATE = 0,
    RTC_MEDIA_STREAM_DISCONNECTED_STATE,
    RTC_MEDIA_STREAM_CONNECTED_STATE,
};

typedef NS_ENUM(NSInteger, RtcStreamChange) {
    RTC_STREAM_ADD = 1,
    RTC_STREAM_REMOVE,
};

typedef NS_ENUM(NSInteger, RtcErrorCodes) {
    NO_ERR = 0,
    ERR_INTERNAL = 500,             // 内部错误
    ERR_LOGIN_ROOM_PARAMS,          // 登录参数错误
    ERR_CHANNEL_IO_EXCEPTION,       // 信令错误
    ERR_CHANNEL_IO_DISCARD_BY_REMOTE,  // 信令被远端关闭
    ERR_AUDIO_DEVICE_CAPTURE,       // 音频采集错误
    ERR_AUDIO_DEVICE_CONFIGURE,     // 音频设备配置错误
    ERR_RECONNECT_OVER_MAX_COUNT,    // 重连接超限
    ERR_SESSION_DESCRIPTION,         // 内部SDP错误
    ERR_INVALID_PARAMS,              // 参数错误
    ERR_VIDEO_VIEW_NOT_EXIST = 510,  // 视频视图不存在
    ERR_VIDEO_VIEW_CANNOT_SNAPSHOT,  // 视频视图未实现截图能力
    ERR_VIDEO_VIEW_SNAPSHOT_EMPTY,   // 视频视图截图结果为空
};

typedef NS_ENUM(NSInteger, RtcWarnCodes) {
    NO_WARNING = 0,
    WARNING_CHANNEL_IO = 700,             // 信令警告
};

typedef NS_ENUM(NSInteger, RTCKeyExchangeMethod) {
    // DTLS.
    kRTCKeyExchangeDTLS = 1,
    // SDES.
    kRTCKeyExchangeSDES,
    // NONE
    kRTCKeyExchangeNONE,
};

typedef NS_ENUM(NSInteger, RtcParamSettingType) {
    RTC_VIDEO_PARAM_SETTINGS_TARGET_ENCODE_DICT,
    RTC_PARAM_SETTINGS_ALL
};

typedef NS_ENUM(NSInteger, RtcVideoEncodeType) {
    RTC_VIDEO_ENCODE_TYPE_H264 = 0,
    RTC_VIDEO_ENCODE_TYPE_VP8,
    RTC_VIDEO_ENCODE_TYPE_VP9,
    RTC_VIDEO_ENCODE_TYPE_H263,
    RTC_VIDEO_ENCODE_TYPE_HEVC,
    RTC_VIDEO_ENCODE_TYPE_JPEG,
    RTC_VIDEO_ENCODE_TYPE_OTHER
};

typedef NSString *RtcVideoDegradationPreference NS_TYPED_ENUM;

extern RtcVideoDegradationPreference const RTC_VIDEO_DEGRADATION_PREFERENCE_MAINTAIN_FRAMERATE;
extern RtcVideoDegradationPreference const RTC_VIDEO_DEGRADATION_PREFERENCE_MAINTAIN_RESOLUTION;
extern RtcVideoDegradationPreference const RTC_VIDEO_DEGRADATION_PREFERENCE_BALANCED;

typedef NS_ENUM(NSInteger, RtcAudioEncodeType) {
    RTC_AUDIO_ENCODE_TYPE_OPUS = 0,
    RTC_AUDIO_ENCODE_TYPE_AAC,
    RTC_AUDIO_ENCODE_TYPE_EAAC,
    RTC_AUDIO_ENCODE_TYPE_SPEEX,
    RTC_AUDIO_ENCODE_TYPE_AMRWB,
    RTC_AUDIO_ENCODE_TYPE_PCMU,
    RTC_AUDIO_ENCODE_TYPE_PCMA,
    RTC_AUDIO_ENCODE_TYPE_G722,
    RTC_AUDIO_ENCODE_TYPE_OTHER
};

typedef NS_ENUM(NSInteger, BRTCAudioProfileType) {
    BRTC_AUDIO_PROFILE_DEFAULT              = 0,
    BRTC_AUDIO_PROFILE_LOW_QUALITY          = 1,    //采样率8KHz, 单声道, 最大编码码率12Kbps.
    BRTC_AUDIO_PROFILE_STANDARD             = 2,    //采样率16KHz, 单声道, 最大编码码率32Kbps.
    BRTC_AUDIO_PROFILE_HIGH_QUALITY         = 3,    //采样率48KHz, 单声道, 最大编码码率48Kbps.
    BRTC_AUDIO_PROFILE_STEREO_HIGH_QUALITY  = 4,    //采样率48KHz, 双声道, 最大编码码率80Kbps.
    BRTC_AUDIO_PROFILE_SUPER_QUALITY        = 5,    //采样率48KHz, 单声道, 最大编码码率96Kbps.
    BRTC_AUDIO_PROFILE_STEREO_SUPER_QUALITY = 6,    //采样率48KHz, 双声道, 最大编码码率128Kbps.
};

typedef NS_ENUM(NSInteger, BRTCAudioScenario) {
    BRTC_AUDIO_SCENARIO_DEFAULT             = 0,    //默认设置为语音场景
    BRTC_AUDIO_SCENARIO_SPEECH              = 1,    //语音场景：语音清晰及传输稳定流畅，适用于双向语音通信场景.
    BRTC_AUDIO_SCENARIO_MUSIC               = 2,    //音乐场景：高品质音乐音质，适用于高音质的场景.
    BRTC_AUDIO_SCENARIO_METAVERSE           = 3,    //元宇宙场景：支持高音质及空间音效
  //BRTC_AUDIO_SCENARIO_CHATROOM            = 4,
};

typedef NS_ENUM(NSInteger, RtcAudioSessionNotificationType) {
    RTC_AUDIO_SESSION_NOTIFICATION_BEGIN_INTERRUPTION = 0,
    RTC_AUDIO_SESSION_NOTIFICATION_END_INTERRUPTION,
    RTC_AUDIO_SESSION_NOTIFICATION_CHANGE_ROUTE,
    RTC_AUDIO_SESSION_NOTIFICATION_MEDIA_SERVER_TERMINATED,
    RTC_AUDIO_SESSION_NOTIFICATION_MEDIA_SERVER_RESET,
    RTC_AUDIO_SESSION_NOTIFICATION_BEGIN_START_PLAY_OR_RECORD,
    RTC_AUDIO_SESSION_NOTIFICATION_BEGIN_STOP_PLAY_OR_RECORD,
    RTC_AUDIO_SESSION_NOTIFICATION_CHANGE_OUTPUT_VOLUME
};

typedef NS_ENUM(NSInteger, RtcSoundMode) {
    RTC_SOUND_MODE_SPEAKER = 0,
    RTC_SOUND_MODE_EAR
};

typedef NS_ENUM(NSInteger, RtcTransportAudioChannel) {
    RTC_AUDIO_MONO = 0,
    RTC_AUDIO_STEREO
};

typedef NS_ENUM(NSInteger, RtcAudioBitrateMode) {
    RTC_AUDIO_BITRATE_CBR = 0,
    RTC_AUDIO_BITRATE_VBR
};

typedef NS_ENUM(NSInteger, RtcSignalChannelMode) {
    RTC_SIGNAL_CHANNEL_MODE_TCP = 0,
    RTC_SIGNAL_CHANNEL_MODE_QUIC,
    RTC_SIGNAL_CHANNEL_MODE_UDP,
};

typedef NS_ENUM(NSInteger, RTCVideoViewScaleMode) {
    RTCVideoViewScaleToFill = 0,
    RTCVideoViewScaleAspectFit,      // contents scaled to fit with fixed aspect. remainder is transparent
    RTCVideoViewScaleAspectFill     // contents scaled to fill with fixed aspect. some portion of content may be clipped.
};

typedef NS_ENUM(NSInteger, RtcVideoBgPushMode) {
    BRTC_VIDEO_BG_PUSH_NOT = 0,
    BRTC_VIDEO_BG_PUSH_BLACKFRAME,
    BRTC_VIDEO_BG_PUSH_LASTFRAME
};

/** 媒体类型 */
typedef NS_ENUM(NSInteger, BRTCMediaType) {
    BRTC_NULL_MEDIA_TYPE = 0,
    BRTC_VIDEO_MEDIA_TYPE,
    BRTC_AUDIO_MEDIA_TYPE,
    BRTC_DATA_MEDIA_TYPE,
};

/** 角色类型 */
typedef NS_ENUM(NSInteger, BRTCRoleType) {
    BRTC_ROLE_ANCHOR   = 1,    /** 默认 主播角色 */
    BRTC_ROLE_AUDIENCE = 2,    /** 观众角色 */
};


typedef NSString *RtcMediaTarget NS_TYPED_ENUM;

// Media target for default video stream, normally it's from system camera.
extern RtcMediaTarget const RTC_MEDIA_TARGET_VIDEO_DEFAULT;

// Media target for default audio stream, normally it's from system microphone.
extern RtcMediaTarget const RTC_MEDIA_TARGET_AUDIO_DEFAULT;

// Media target for screen sharing video, normally it's from app or system screen capturing content.
extern RtcMediaTarget const RTC_MEDIA_TARGET_VIDEO_SCREEN;

// Media target for screen sharing audio,, normally it's from in-app sound
extern RtcMediaTarget const RTC_MEDIA_TARGET_AUDIO_SCREEN;

@interface RtcVideoFrame : NSObject

@property (nonatomic, assign, readonly) CVPixelBufferRef pixelBuffer;
@property (nonatomic, assign) CMTime time;
@property (nonatomic, assign, readonly) CGFloat width;
@property (nonatomic, assign, readonly) CGFloat height;
@property (nonatomic, assign) BaiduVideoRotation rotation;

+ (instancetype)frameWithPixelBuffer:(CVPixelBufferRef)pixelBuffer time:(CMTime)time;

@end

#pragma mark -- live related define.
@interface RtcLiveAuidoVideoParameters : NSObject<NSCopying>
//Video parameters
@property(nonatomic, assign) UInt32 fps;
@property(nonatomic, assign) UInt32 width;
@property(nonatomic, assign) UInt32 height;
@property(nonatomic, assign) UInt32 vBitrate;
@property(nonatomic, assign) RtcVideoEncodeType vEncodeType;

//Audio parameters
@property(nonatomic, assign) UInt32 sampleRate;
@property(nonatomic, assign) UInt32 sampleSize;
@property(nonatomic, assign) UInt32 channelCount;
@property(nonatomic, assign) UInt32 aBitRate;
@property(nonatomic, assign) RtcAudioEncodeType aEncodeType;
@end

@interface LiveServerInfo : NSObject<NSCopying>
@property (nonatomic, assign) BOOL isEnable;
@property (nonatomic, copy) NSString *url;
@property (nonatomic, copy) NSString *mixTemplate;
@property (nonatomic, assign) BOOL isMix;
@property (nonatomic, assign) BOOL isReocrding;
@property (nonatomic, copy) RtcLiveAuidoVideoParameters *avParam;
@end

typedef NS_ENUM(NSInteger, RtcLiveTransferMode) {
    RTC_LIVE_TRANSFER_MODE_ROOM_TRANSMISSION = 0,
    RTC_LIVE_TRANSFER_MODE_ANCHOR_TRASNSMISSION
};
typedef NS_ENUM(NSInteger, RtcLiveTransferState) {
    RTC_LIVE_PUBLISH_SUCCESS_STATE = 1,
    RTC_LIVE_PUBLISH_FAIL_STATE,
    RTC_LIVE_PUBLISH_INTRERRUPT_STATE,
};

typedef NS_ENUM(NSInteger, RtcMediaRealyType) {
    START_MEDIA_RELAY = 1,
    STOP_MEDIA_RELAY,
};

typedef NS_ENUM(NSInteger, RtcMediaRealyState) {
    MEDIA_RELAY_SUCC = 1,
    MEDIA_RELAY_FAIL,
};

typedef NS_ENUM(NSInteger, RtcServerMixTemplate) {
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_360P_4_3 = 0,  //主次平铺, 分辨率480x360
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_360P_16_9, //主次平铺, 分辨率640x360
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_480P_4_3,  //主次平铺, 分辨率640x480
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_480P_16_9, //主次平铺, 分辨率854x480
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_720P_4_3,  //主次平铺, 分辨率960x720
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_PRIMARY_720P_16_9, //主次平铺, 分辨率1280x720

    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_360P_4_3,  //平铺模式(大小相等), 分辨率480x360
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_360P_16_9, //平铺模式(大小相等), 分辨率640x360
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_480P_4_3,  //平铺模式(大小相等), 分辨率640x480
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_480P_16_9, //平铺模式(大小相等), 分辨率854x480
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_720P_4_3,  //平铺模式(大小相等), 分辨率960x720
    RTC_SERVER_MIX_TEMPLATE_SIDE_BY_SIDE_EQUAL_720P_16_9, //平铺模式(大小相等), 分辨率1280x720

    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_360P_4_3,  //画中画模式, 分辨率480x360
    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_360P_16_9, //画中画模式, 分辨率640x360
    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_480P_4_3,  //画中画模式, 分辨率640x480
    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_480P_16_9, //画中画模式, 分辨率854x480
    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_720P_4_3,  //画中画模式, 分辨率960x720
    RTC_SERVER_MIX_TEMPLATE_PICTURE_IN_PICTURE_BOTTOM_720P_16_9, //画中画模式, 分辨率1280x720
};

typedef NS_ENUM(NSInteger, RtcNetworkDetectionMode) {
    RTC_NETWORK_DETECTION_MODE_HIGHT_BANDWIDTH_HIGHT_LOSS = 1, // 高带宽高丢包模式（激进模式）
    RTC_NETWORK_DETECTION_MODE_LIMIT_BANDWIDTH_HIGHT_LOSS      // 有限带宽高丢包模式 （防守模式）
};

/** Network quality. */
typedef NS_ENUM(NSUInteger, RtcNetworkQuality) {
    /** The network quality is unknown. */
    RtcNetworkQualityUnknown = 0,
    /**  The network quality is excellent. */
    RtcNetworkQualityExcellent = 1,
    /** The network quality is quite good, but the bitrate may be slightly lower than excellent. */
    RtcNetworkQualityGood = 2,
    /** Users can feel the communication slightly impaired. */
    RtcNetworkQualityPoor = 3,
    /** Users can communicate only not very smoothly. */
    RtcNetworkQualityBad = 4,
     /** The network quality is so bad that users can hardly communicate. */
    RtcNetworkQualityVBad = 5,
     /** The network is disconnected and users cannot communicate at all. */
    RtcNetworkQualityDown = 6,
     /** Users cannot detect the network quality. (Not in use.) */
    RtcNetworkQualityUnsupported = 7,
     /** Detecting the network quality. */
    RtcNetworkQualityDetecting = 8,
};

typedef NS_ENUM(NSInteger, NSSubscribeMode) {
    kSubscribeModeManual = 0,
    kSubscribeModeAuto,
    kSubscribeModeMeeting
};

@interface RtcVideoBaseParams : NSObject<NSCopying>

@property (nonatomic, assign) int videoFps;
@property (nonatomic, assign) int videoWidth;
@property (nonatomic, assign) int videoHeight;

@end

/// Param settings for video encoding
@interface RtcVideoEncodeParams : RtcVideoBaseParams<NSCopying>
@property (nonatomic, assign) int gopSize; // unit: frames
@property (nonatomic, assign) int videoBitrate; // unit: kbps
@property (nonatomic, assign) int videoMinBitrate;  // unit: kbps
@property (nonatomic, assign) RtcVideoEncodeType videoCodecType;
 
@end

@interface RtcParameterSettings : NSObject
// Audio
@property (nonatomic, assign) BOOL hasAudio;
/// 是否自动订阅远端音频流，默认 YES
@property (nonatomic, assign) BOOL hasRemoteAudio;
@property (nonatomic, assign) BOOL isCreatingAecDump;
@property (nonatomic, assign) BOOL isUsingLevelControl;
@property (nonatomic, assign) BOOL isUsingManualConfig;
@property (nonatomic, assign) BOOL isExportAudioRecord;
@property (nonatomic, assign) BOOL isExportAudioPlayout;
@property (nonatomic, assign) BOOL isExportAudioRecordPlayoutMix;
@property (nonatomic, assign) BOOL isEnableExternalAudioDevice;
@property (nonatomic, assign) BOOL disableAudioMixWithOthers;
@property (nonatomic, assign) int audioSampleRate;
@property (nonatomic, assign) int audioBitrate; // unit : kbps
@property (nonatomic, assign) RtcAudioBitrateMode audioBitrateMode;
@property (nonatomic, assign) RtcTransportAudioChannel audioChannelTransport;
@property (nonatomic, assign) BOOL isSoftNsEnable;
@property (nonatomic, assign) int audioJitterBufferSize;
@property (nonatomic, assign) int playoutDelayAudioOnly;
@property(nonatomic, assign) int audioCodeComplex; // value [0 - 10]
@property (nonatomic, assign) BOOL audioLevelEnable;
@property (nonatomic, assign) int audioLevelTopCount;
@property (nonatomic, assign) RtcAudioEncodeType audioCodecType;
@property (nonatomic, assign) RtcNetworkDetectionMode networkDetectionMode; // 带宽探测模式（用于POC环境/实验室环境测试）

@property (nonatomic, assign)BRTCAudioProfileType audioProfileType; //设置音频的类型
@property (nonatomic, assign)BRTCAudioScenario    audioScenario;    

// Video
@property (nonatomic, assign) BOOL hasVideo;
/// 是否自动订阅远端视频流，默认 YES
@property (nonatomic, assign) BOOL hasRemoteVideo;
@property (nonatomic, assign) int subscribeCount;
@property (nonatomic, assign) int netEqMaxDelay; // unit: ms
@property (nonatomic, assign) NSSubscribeMode subscribeMode;
@property (nonatomic, assign) BOOL isEnableExternalRender;
@property (nonatomic, assign) BOOL isEnableHighProfile;
@property (nonatomic, assign) BOOL isEnableVBR;
@property (nonatomic, assign) BOOL isIgnoreUnknownSEI;
@property (nonatomic, assign) BOOL isEnableFixedResolution;
@property (nonatomic, assign) BOOL isEnableVideoDump;
@property (nonatomic, assign) BOOL isVideoFramingEnhance;
@property (nonatomic, assign) BOOL isEnableJitterRetransmission;
@property (nonatomic, assign) RtcVideoBgPushMode videoBgPushMode;
@property (nonatomic, assign) BOOL isEnableReportWatchSli;
@property (nonatomic, assign) BOOL isEnableVideoPullDemote;
@property (nonatomic, assign) BOOL isEnableFec; // default is true
@property (nonatomic, assign) BOOL isEnableNetworkQuality; // default is false
@property (nonatomic, assign) RTCKeyExchangeMethod keyExchangeMethod;

/// 上行视频降级策略，默认 MAINTAIN_FRAMERATE
/// @discussion 注意当该配置为 MAINTAIN_FRAMERATE 或 BALANCED 时，若同时开启了 isEnableFixedResolution，分辨率动态调整策略会失效
@property (nonatomic, assign) RtcVideoDegradationPreference degradationPreference;

/// 采集视频参数设置
@property (nonatomic, copy) RtcVideoBaseParams *videoCaptureParams;

/// 为指定类型的视频流设置视频参数
@property (nonatomic, copy) NSDictionary<RtcMediaTarget, RtcVideoEncodeParams *> *videoEncodeParams;

//发布订阅流
@property(nonatomic) BOOL isAutoPublish;
@property(nonatomic) BOOL isAutoSubscribe;

// Data channel
@property (nonatomic, assign) BOOL hasData;

// multistream
@property (nonatomic, assign) BOOL enableMultiStream;

// Audio Device
@property (nonatomic, assign) BOOL enablePlayStereo BRTC_DEPRECATED("Use setAudioProfile:scenrio: instead");

// 是否启用内部美颜
@property (nonatomic, assign) BOOL enableBeauty;

// 是否启用内部音频处理
@property (nonatomic, assign) BOOL enableAudioProcess;

//是否开启水印
@property (nonatomic, assign) BOOL enableVideoProcess;


// rtmp
@property (nonatomic, assign) LiveServerInfo *roomTransInfo;
@property (nonatomic, assign) LiveServerInfo *anchorTransInfo;
@property (nonatomic, assign) BOOL isMixing;
@property (nonatomic, copy) NSString *rtmpUrl;
@property (nonatomic, assign) RtcLiveTransferMode liveTransferMode;

// signal channel
@property (nonatomic, assign) RtcSignalChannelMode signalChannelMode;
@property (nonatomic, assign) BOOL isOnlineMode;
// prune signal
@property (nonatomic, assign) BOOL enablePruneSignal;
@property (nonatomic, copy) NSString *signalServerUrl;

// screen share
@property (nonatomic, assign) NSInteger systemScreenShareUserId;
@property (nonatomic, copy) NSString *systemScreenShareDisplayName;


// log
@property (nonatomic, assign) BOOL enableLogQualityMonitor;
@property (nonatomic, assign) BOOL enableLogWeakNetQuality;
@property (nonatomic, assign) BOOL enableLogPost;

// 网络重连接
@property (nonatomic, assign) BOOL enableAutoReconnect;

@end

@interface BRTCScreenShareAudioParams : NSObject<NSCopying>
/// 系统音频流采集音量，[0, 100]，默认 100
@property (nonatomic, assign) NSInteger volume;
- (instancetype)initWithDict:(NSDictionary *)dict;
@end

@interface BRTCScreenShareVideoParams : RtcVideoEncodeParams
- (instancetype)initWithDict:(NSDictionary *)dict;
@end

/// 屏幕分享配置参数
@interface BRTCScreenShareParams : NSObject<NSCopying>

/// 是否分享系统音频流分享
@property (nonatomic, assign) BOOL enableAudioCapture;

/// 音频流配置参数
@property (nonatomic, copy) BRTCScreenShareAudioParams *audioCaptureParams;

/// 是否分享系统屏幕视频流
@property (nonatomic, assign) BOOL enableVideoCapture;

/// 屏幕视频流配置参数
@property (nonatomic, copy) BRTCScreenShareVideoParams *videoCaptureParams;

- (instancetype)initWithDict:(NSDictionary *)dict;

@end

/** 登录参数 */
@interface LoginOptions : NSObject
@property (nonatomic, assign) BOOL isCompulsive;
@property (nonatomic, assign) BRTCRoleType roleType;
@property (nonatomic, strong) NSString *tokenStr;
@end

#endif /* BaiduRtcRoomApiDefines_h */
