//
//  BaiduChatAgentDelegate.h
//
//  Created by Sun,Jian(ACU-T102) on 2024/1/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, AgentConnectionState) {
    CONNECTION_STATE_DISCONNECTED = 1,
    CONNECTION_STATE_CONNECTING,
    CONNECTION_STATE_CONNECTED,
    CONNECTION_STATE_RECONNECTING,
};

typedef NS_ENUM(NSInteger, ErrorType) {
    ERR_INIT = 400,
    ERR_CALL_PARAMS = 401,
    ERR_UN_KNOW = 402,
    ROOM_DISBAND = 900,
    USER_KICK_OFF = 901,
    USER_TOO_MANY = 902
};

typedef NS_ENUM(NSInteger, AGentCallState) {
    AGENT_CALL_BEGIN = 1,
    AGENT_CALL_END
};

typedef NS_ENUM(NSInteger, AGentConnectState) {
    AGENT_CONNECTION_STATE_DISCONNECTED = 1,
    AGENT_CONNECTION_STATE_CONNECTING,
    AGENT_CONNECTION_STATE_CONNECTED,
    AGENT_CONNECTION_STATE_RECONNECTING
    
};

typedef NS_ENUM(NSInteger, AGentAudioState) {
    AGENT_STOPPED = 1,
    AGENT_SPEAKING
};

typedef NS_ENUM(NSInteger, AgentErrorCode) {
    AgentErrorCodeNoError = 1000,
    
    AgentErrorCodeFileInvalid       = 1001,
    AgentErrorCodeFileUnsupported   = 1002,
    AgentErrorCodeFileTooLarge      = 1003,
    
    AgentErrorCodeLicenseAuthFail   = 4001,
};

#pragma mark -- 提供app的callback
@protocol BaiduChatAgentDelegate <NSObject>

@optional

/**
 *  错误信息回调
 *  @param errCode 错误号码
 *  @param errMsg  错误消息提示
 *  @param extInfo 附加信息
 */
- (void)onError:(NSInteger)errCode errMsg:(NSString *)errMsg extInfo:(nullable NSDictionary*)extInfo;

/**
 * 状态变化
 */
- (void)onCallStateChange:(AGentCallState)state;

/**
 * 链接状态变化
 */
- (void)onConnectionStateChange:(AGentConnectState)state;


/**
 * 用户端音频ASR结果
 */
- (void)onUserAsrSubtitle:(NSString *)text isFinal:(BOOL)isFinal;


/**
 * AI智能体结果
 */
- (void)onAIAgentSubtitle:(NSString *)text isFinal:(BOOL)isFial;


/**
 * AI智能体音频状态变化
 */
- (void)onAIAgentAudioStateChange:(AGentAudioState)newState;

/**
 * 用户声音状态变化
 */
- (void)onUserAudioStateChange:(AGentAudioState)newState;


/**
 * 智能体音频能量
 */
- (void)onAIAgentAudioLevel:(NSInteger)level;

/**
 * 用户音频能量
 */
- (void)onUserAudioLevel:(NSInteger)level;

/**
 * functionCall
 * @param id functionCall 单次唯一标识
 * @param params json参数
 * */
- (void) onFunctionCall:(NSString*) functionID param:(NSString*) params;

/**
 文件上传状态回调
 * @param code 状态码
 */
- (void)onUploadFileStatus:(AgentErrorCode)code fileName:(NSString *)fileName;

/**
 * Agent 意图
 * @param type 意图类型，暂时支持 [image, video]
 * @param extInfo 附加信息
 */
- (void)onAgentIntent:(NSString *)type extInfo:(NSDictionary * __nullable)extInfo;

/**
 * license 授权状态回调
 * @param status 授权状态: 0 成功; -1 失败
 */
- (void)onAgentLicenseStatus:(int)status;

@end

NS_ASSUME_NONNULL_END
