//
//  BaiduChatAgentDefines.h
//
//  Created by Sun,Jian(ACU-T102) on 2024/1/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NSString *BaiduAIAgentWorkFlowType NS_TYPED_ENUM;

extern BaiduAIAgentWorkFlowType const BAIDU_AI_AGENT_WORK_FLOW_VOICE_CHAT;
extern BaiduAIAgentWorkFlowType const BAIDU_AI_AGENT_WORK_FLOW_VIDEO_CHAT;

@interface AgentEngineParams : NSObject

/** 服务器端接口下发 cid, token， 当前调试传入空即可 { "cid": 1, "token": "xxx-aa-bb" }*/
@property (nonatomic, copy) NSString *config;

/** appid */
@property (nonatomic, copy) NSString *appId;

/** 工作流类型，默认用VoiceChat */
@property (nonatomic, assign) NSString * workFlow;

/** 实例id  服务器端下发，当前调试默认即可 */
@property (nonatomic, assign) NSInteger instanceId;
/** 调试开关 */
@property (nonatomic, assign) BOOL verbose;

/** 语音自动打断 */
@property (nonatomic, assign) BOOL enableVoiceInterrupt;

/** 本地音频打断能量值 默认80 */
@property (nonatomic, assign) NSInteger userAudioLevelInterrupt;

/** 授权 key */
@property (nonatomic, copy) NSString *licenseKey;

/** 用户 id */
@property (nonatomic, copy) NSString *userId;

@end
