//
//  BaiduChatAgent.h
//
//  Created by Sun,Jian(ACU-T102) on 2024/1/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//
#import <Foundation/Foundation.h>
#import "BaiduChatAgentDefines.h"
#import <BaiduRtcRoom/BaiduRtcRoomApi.h>

@protocol BaiduChatAgentDelegate;
@class RTCRemoteVideoView;
@interface BaiduChatAgent : NSObject

/**
 * 初始化
 * @param params 参数
 * @param delegate 回调
 */
- (id)initWithParams:(AgentEngineParams*) params delegate:(id<BaiduChatAgentDelegate>)delegate;

/**
 * 开启对话
 * @param token  鉴权token
 * @param instanceId  实例id
 */
- (void)call:(NSString *)token instanceId:(NSInteger)instanceId;

/**
 * 挂断
 */
- (void)hangup;


/**
 * 资源销毁
 */
- (void)destroy;

/**
 * 打断智能体播报
 * */
- (void)interrupt;


/** 
 * 静音播放
 * @param isMute 是否静音
 * */
- (void)mutePlayback:(BOOL)isMute;

/** 
 * 静音mic
 * @param isMute  是否静音
 * */
- (void)muteMic:(BOOL)isMute;

/** 
 * 切换扬声器
 * @param speaker 是否扬声器
 * */
- (void)switchToSpeaker:(BOOL)speaker;

/**
 * 预置听筒/扬声器
 * @param isSpeaker   true:扬声器   false:听筒    默认听筒
 * @discussion 在 initWithParams 之后，call 之前调用，预置听筒/扬声器播放语音
 */
- (void)presetLoudSpeaker:(BOOL)isSpeaker;

/**
 * 发送文本给智能体
 * @param text 文本
 */
- (void)sendTextToAIAgent:(NSString *)text;

/**
 * 发送文本给智能体，并且打断当前播报
 * @param text 文本
 */
- (void)sendTextToAIAgentAndInterrupt:(NSString *)text;

/**
 * 发送文本给TTS，直接进行播报
 * @param text 文本
 */
- (void)sendTextToTTS:(NSString *)text;

/**
  * 发送functionCall 结果
  * @param id 唯一标识
  * @param result 结果
  * */
- (void)sendFunctionCallResult:(NSString*) functionID result:(NSString *)msg;

/**
  * 设置数字人 view的参数 音频智能体不用调用该接口
  * @param remoteVideoView
  * */
- (void)setDigitalDisplay:(RTCRemoteVideoView *) remoteVideoView;

/**
 * 上传文件
 * @param path 文件路径
 * @param expire 过期时间，最大 180s
 */
- (BOOL)uploadFile:(NSString *)path expire:(NSInteger)expire;

/**
 * 设置本地相机预览视图
 * @param localVideoView 本地预览视图
 */
- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView;

/**
 * 打开相机预览
 */
- (void)startCameraPreview;

/**
 * 关闭相机预览
 */
- (void)stopCameraPreview;

/**
 * 翻转相机
 */
- (void)switchCamera;


@end


