//
//  MainViewController.m
//  ChatAgentApp
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "MainViewController.h"
#import "MainView.h"
#import "AIChatAgentController.h"
#import "BCALicenseManager.h"
//#import "ChatViewController.h"
#import <BaiduChatAgent/BaiduChatAgentDefines.h>
#import "BDCloudRTCBaseDefine.pch"

@interface MainViewController () <MainViewDelegate, AIChatAgentControllerDelegate>
@end

@implementation MainViewController {
    MainView *_mainView;
    
}

- (void)dealloc {
    NSLog(@"MainViewController dealloc");
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    //disable rest screen
    [[UIApplication sharedApplication] setIdleTimerDisabled:YES];
    
    [BCALicenseManager sharedManager];
    
    if (@available(iOS 13.0, *)) {
        self.navigationController.navigationBar.backgroundColor = [UIColor systemBackgroundColor];
    }
}

- (void)loadView {
    _mainView = [[MainView alloc] initWithFrame:CGRectZero];
    _mainView.delegate = self;
    self.view = _mainView;
}


#pragma mark - MainViewDelegate
- (void)mainView:(MainView *)mainView
         didCall:(NSString *)channelId
          config:(NSString *)param
             app:(NSString *)appID
            user:(NSString *)userId
              hd:(BOOL)env{
    NSLog(@"【config】:%@", param);
    if (mainView.licenseKey.length > 0) {
        [BCALicenseManager setLicenseKey:mainView.licenseKey forAppID:([appID length] > 0 ? appID : BDCloudDefaultRTCAppID)];
    }
    AIChatAgentController *ctr = [[AIChatAgentController alloc] initWithParams:self conf:param app:appID user:userId hd:env];
    ctr.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:ctr
                       animated:YES
                     completion:nil];
}

#pragma mark - AIChatAgentControllerDelegate

- (void)viewControllerDidFinish:(AIChatAgentController *)viewController {
    if (![viewController isBeingDismissed]) {
        NSLog(@"Dismissing VC");
        [self dismissViewControllerAnimated:YES completion:^{
        }];
    }
}

#pragma mark - Private

- (void)presentViewControllerAsModal:(UIViewController *)viewController {
    [self presentViewController:viewController animated:YES completion:nil];
}

- (void)showAlertWithMessage:(NSString*)message {
    UIAlertController *alert =
    [UIAlertController alertControllerWithTitle:nil
                                        message:message
                                 preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"OK"
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction *action){
    }];
    
    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}


@end
