//
//  RouteCollectionViewLayout.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/15.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString * const kRouteSupplementaryIconKind;
extern NSString * const kRouteSupplementaryLineKind;
extern NSString * const kRouteSupplementaryFooterKind;
extern NSString * const kRouteDecorationSpliterKind;

@protocol RouteCollectionViewLayoutDelegate;

@interface RouteCollectionViewLayout : UICollectionViewLayout

@property (nonatomic, assign) UIEdgeInsets contentInsets;

@property (nonatomic, assign) CGFloat leftPanelWidth;
@property (nonatomic, assign) CGFloat rightPanelWidth;
@property (nonatomic, assign) CGFloat lineWidth;
@property (nonatomic, assign) CGFloat cellWidth;
@property (nonatomic, assign) CGSize contentSize;
@property (nonatomic, assign) CGFloat linePadding;
@property (nonatomic, assign) CGSize supplementaryIconSize;
@property (nonatomic, strong) NSMutableDictionary *layoutInfomation;


@property (nonatomic, weak) id<RouteCollectionViewLayoutDelegate> delegate;

- (CGSize)sizeForFooter;
- (CGSize)sizeForCellAtIndexPath:(NSIndexPath *)indexPath;
- (CGSize)sizeForIconAtIndexPath:(NSIndexPath *)indexPath;

@end

@protocol RouteCollectionViewLayoutDelegate <NSObject>

- (CGFloat)routeCollectionViewLayout:(RouteCollectionViewLayout *)layout heightForItemAtIndexPath:(NSIndexPath *)indexPath;

@optional
- (CGSize)routeCollectionViewLayout:(RouteCollectionViewLayout *)layout sizeForIconAtIndexPath:(NSIndexPath *)indexPath;

- (CGFloat)heightForFooterInRouteCollectionViewLayout:(RouteCollectionViewLayout *)layout;

@end

NS_ASSUME_NONNULL_END
