//
//  NSAttributedString+Ext.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/15.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "NSAttributedString+Ext.h"

@implementation NSMutableAttributedString (Ext)

- (void)ext_setFont:(UIFont *)font {
    [self ext_setFontName:font.fontName size:font.pointSize];
}

- (void)ext_setFont:(UIFont *)font range:(NSRange)range {
    [self ext_setFontName:font.fontName size:font.pointSize range:range];
}

- (void)ext_setFontName:(NSString *)fontName size:(CGFloat)size {
    [self ext_setFontName:fontName size:size range:NSMakeRange(0,[self length])];
}

- (void)ext_setFontName:(NSString *)fontName size:(CGFloat)size range:(NSRange)range {
    UIFont *font = [UIFont fontWithName:fontName size:size];
    if (font) {
        [self removeAttribute:NSFontAttributeName range:range];
        [self addAttribute:NSFontAttributeName value:font range:range];
    }
}

- (void)ext_setTextColor:(UIColor *)color {
    [self ext_setTextColor:color range:NSMakeRange(0,[self length])];
}

- (void)ext_setTextColor:(UIColor *)color range:(NSRange)range {
    if(color == nil || range.length == 0){
        return;
    }
    [self removeAttribute:NSForegroundColorAttributeName range:range];
    [self addAttribute:NSForegroundColorAttributeName value:color range:range];
}

@end
