//
//  LoadingAnimationBar.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "LoadingView.h"
#import "LoadingFailedView.h"

NS_ASSUME_NONNULL_BEGIN

@protocol LoadingAnimationBarDelegate <NSObject>

- (void)retryRoutePlan;

@end

@interface LoadingAnimationBar : UIView

@property (nonatomic, weak) id<LoadingAnimationBarDelegate> delegate;

@property (nonatomic, strong) LoadingView *animationView;

@property (nonatomic, strong) LoadingFailedView *failedView;

@property (nonatomic, strong) UILabel *retryLabel;

// 状态label
- (void)setLoadingText:(NSString*)text;

// 切换路线失败
- (void)updateFailedMessage:(NSString*)message withRetryButtonShow:(BOOL)isShowed;

- (void)startAnimation;

- (void)stopAnimation;

- (void)hideIconView:(BOOL)hide;

@end

NS_ASSUME_NONNULL_END
