//
//  BCAFuncallHandler.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/18.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface BCAFuncallItem : NSObject

@property (nonatomic, copy) NSString *sessionId;
@property (nonatomic, copy) NSString *functionName;
@property (nonatomic, copy) NSDictionary *functionParams;

@end

typedef NS_ENUM(NSInteger, BCAFuncallResult) {
    BCAFuncallResultSuccess = 0,
    BCAFuncallResultFail = 1,
};

@protocol BCAFuncallHandler;
@class BCAFuncallResultView;

@protocol BCAFuncallHandlerDelegate <NSObject>

- (void)funcallHandler:(id<BCAFuncallHandler> _Nullable)handler executeFinished:(NSString *)sessionId
               message:(NSString * _Nullable)message
                 error:(NSError * _Nullable)error;

- (void)funcallHandler:(id<BCAFuncallHandler> _Nullable)handler sendTextToTTS:(NSString *)text;

// 获取互动页面控制器，用于funcall视图交互
- (UIViewController *)funcallHandlerChatViewController:(id<BCAFuncallHandler>)handler;

@end

@protocol BCAFuncallHandler <NSObject>

@property (nonatomic, weak) id<BCAFuncallHandlerDelegate> delegate;

- (BCAFuncallItem *)funcallItem;

- (BCAFuncallResult)executeFuncallWithItem:(BCAFuncallItem *)item;

// 是否允许退出，不保留函数执行缓存
- (BOOL)shouldExitFuncallHandler;

// 获取函数执行结果视图，用于持续交互
- (BCAFuncallResultView *)funcallResultView;

- (void)onAgentAudioStateChange:(int)state;

@end

@interface BCAFuncallHandler : NSObject

- (BOOL)registerHandlerClass:(Class)cls forType:(NSString *)type;

@property (nonatomic, weak) id<BCAFuncallHandlerDelegate> delegate;

/// 执行 funcall 请求
/// - Parameter sessionId: 函数会话ID
/// - Parameter params: 函数参数，格式如 @"{\"session_id\":\"1744718758902\",\"content\":\"{\\\"function_name\\\":\\\"take_photo\\\",\\\"parameter_list\\\":[]}\"}"
/// - Parameter completion: 执行回调
- (BCAFuncallResult)executeFuncallWithSessionId:(NSString *)sessionId params:(NSString *)params;

- (void)onAgentAudioStateChange:(int)state;

@end

@interface BCAFuncallResultView : UIView

- (CGSize)boundingRectWithSize:(CGSize)size;

- (void)setupViews;

@end

NS_ASSUME_NONNULL_END
