//
//  RTCRemoteVideoView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/29.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//
#ifndef RTCRemoteVideoView_h
#define RTCRemoteVideoView_h
#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#elif TARGET_OS_OSX
#import <AppKit/AppKit.h>
#endif
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

@class RTCRemoteVideoView;

typedef NS_ENUM(int, SrEnabledReason) {
    SrReasonSuccess = 0,
    SrReasonFpsTooLow,
    SrReasonSystem
};

@protocol RTCRemoteVideoViewDelegate<NSObject>
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView didChangeVideoSize:(CGSize)size;
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView videoRenderStuck:(NSInteger)duration;
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView superResolutionEnabled:(BOOL)enabled reason:(SrEnabledReason)reason;
@end

@interface RTCRemoteVideoView : NSObject
#if TARGET_OS_IPHONE
@property (nonatomic, readonly) UIView *videoView;
#elif TARGET_OS_OSX
@property (nonatomic, readonly) NSView *videoView;
#endif
/** 远端视频分辨率 */
@property (nonatomic, readonly) CGSize videoResolution;
@property (nonatomic, weak) id <RTCRemoteVideoViewDelegate> videoViewDelegate;
/** 绑定用户id */
@property (nonatomic, assign) NSInteger userId;
/** 是否开启超分 */
@property (nonatomic, assign) BOOL enableSR;
@property (nonatomic, assign) float srTargetFps;
/** 设置缩放模式 */
@property (nonatomic, assign) RTCVideoViewScaleMode rtcVideoViewMode;
/// 渲染卡顿回调间隔
@property (nonatomic, assign) NSInteger renderStuckInterval;

- (instancetype)initWithDelegate:(id<RTCRemoteVideoViewDelegate>)delegate;
@end

#endif /* RTCRemoteVideoView_h */
