//
//  BCAMapPoiSearchModel.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/5/8.
//

#import "BCAMapPoiSearchModel.h"
#import "BCALocationManager.h"

static NSString *const kParamSearchTypeKey      = @"search_type";
static NSString *const kParamCenterPositionKey  = @"center_position";
static NSString *const kParamCenterRadiusKey    = @"radius";
static NSString *const kParamKeywordKey         = @"keyword";

@implementation BCAMapPoiSearchModel

+ (instancetype)modelWithParams:(NSDictionary *)params {
    return [[[self class] alloc] initWithParams:params];
}

- (instancetype)initWithParams:(NSDictionary *)params {
    if (self = [super init]) {
        [self resolveParams:params];
    }
    return self;
}

- (void)resolveParams:(NSDictionary *)params {
    // 检索类型, 默认周边
    NSString *type = [params objectForKey:kParamSearchTypeKey];
    if ([type.lowercaseString isEqualToString:@"area"]) {
        self.searchType = BCAMapPoiSearchTypeArea;
    } else if ([type.lowercaseString isEqualToString:@"nearby"]) {
        self.searchType = BCAMapPoiSearchTypeNearby;
    } else {
        self.searchType = BCAMapPoiSearchTypeNearby;
    }
    
    // 检索词
    self.keyword = [params objectForKey:kParamKeywordKey];
    
    // 中心位置 & 区域
    self.center = [params objectForKey:kParamCenterPositionKey];
    
    // 半径
    NSNumber *radiusNum = [params objectForKey:kParamCenterRadiusKey];
    self.radius = radiusNum ? radiusNum.integerValue : kMapPoiSearchDefaultRadius;
}

@end
