//
//  BCAMapPoiSearchModel.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/5/8.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BCAMapPoiSearchType) {
    BCAMapPoiSearchTypeArea,
    BCAMapPoiSearchTypeNearby,
};

static NSInteger const kMapPoiSearchDefaultRadius = 1000;

@class BCAMapPoiSearchModel;

@interface BCAMapPoiSearchModel : NSObject

@property (nonatomic, assign) BCAMapPoiSearchType searchType;
@property (nonatomic, copy) NSString *keyword;
@property (nonatomic, copy) NSString *center;
@property (nonatomic, assign) NSInteger radius; // default 1000(m)

+ (instancetype)modelWithParams:(NSDictionary *)params;
- (instancetype)initWithParams:(NSDictionary *)params;

@end

NS_ASSUME_NONNULL_END
