//
//  BCAMapPoiSearchCardView.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/5/8.
//

#import "BCAMapPoiSearchCardView.h"
#import <BaiduMapAPI_Search/BMKSearchComponent.h>

static CGFloat kPadding = 10.f;
static CGFloat kMargin = 5.f;
static CGFloat kLabelHeight = 20.f;

@interface BCAMapPoiSearchCardView ()

@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UIView *separatorLine;
@property (nonatomic, strong) UILabel *nameLabel;
@property (nonatomic, strong) UILabel *addressLabel;
@property (nonatomic, strong) UILabel *ratingLabel;

@end

@implementation BCAMapPoiSearchCardView

- (void)updateWithSearchResult:(BMKPOISearchResult *)result {
    NSInteger totalNum = result.totalPOINum;
    self.titleLabel.text = [NSString stringWithFormat:@"为您找到 %@ 个结果", @(totalNum)];
    
    BMKPoiInfo *info = [result.poiInfoList firstObject];
    self.nameLabel.text = info.name;
    self.addressLabel.text = info.address;
    self.ratingLabel.text = [NSString stringWithFormat:@"评分: %.1f", info.detailInfo.overallRating];
    
    [self setNeedsLayout];
}

- (void)setupViews {
    [super setupViews];
    
    // 标题标签
    self.titleLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    [self addSubview:self.titleLabel];
    
    // 分隔线
    self.separatorLine = [[UIView alloc] init];
    self.separatorLine.backgroundColor = [UIColor lightGrayColor];
    [self addSubview:self.separatorLine];
    
    // 名称标签
    self.nameLabel = [self labelWithFont:16.f color:[UIColor systemBlueColor]];
    [self addSubview:self.nameLabel];
    
    // 评分标签
    self.ratingLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    [self addSubview:self.ratingLabel];
    
    // 地址标签
    self.addressLabel = [self labelWithFont:16.f color:[UIColor darkGrayColor]];
    self.addressLabel.numberOfLines = 0;
    [self addSubview:self.addressLabel];
    
}

- (CGSize)boundingRectWithSize:(CGSize)size {
    CGFloat height = [self cardHeight:size];
    return CGSizeMake(size.width, height);
}

// 计算卡片总高度
- (CGFloat)cardHeight:(CGSize)size {
    CGFloat topHeight = kLabelHeight;
    CGFloat separateHeight = kMargin * 2 + 1.0;
    CGSize addressSize = [self.addressLabel sizeThatFits:CGSizeMake(size.width - 2 * kPadding, 200)];
    CGFloat bottomHeight = kLabelHeight + kMargin + kLabelHeight + kMargin + addressSize.height;
    return kPadding * 2 + topHeight + separateHeight + bottomHeight;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat maxWidth = self.bounds.size.width - 2 * kPadding;
    CGFloat y = kPadding;
    self.titleLabel.frame = CGRectMake(kPadding, y, maxWidth, kLabelHeight);
    y = CGRectGetMaxY(self.titleLabel.frame);
    self.separatorLine.frame = CGRectMake(kPadding, y + kMargin, maxWidth, 1);
    
    y = CGRectGetMaxY(self.separatorLine.frame);
    self.nameLabel.frame = CGRectMake(kPadding, y + kMargin, maxWidth, kLabelHeight);
    
    y = CGRectGetMaxY(self.nameLabel.frame);
    self.ratingLabel.frame = CGRectMake(kPadding, y + kMargin, maxWidth, kLabelHeight);
    
    y = CGRectGetMaxY(self.ratingLabel.frame);
    CGSize addressSize = [self.addressLabel sizeThatFits:CGSizeMake(maxWidth, 200)];
    self.addressLabel.frame = CGRectMake(kPadding, y + kMargin, addressSize.width, addressSize.height);
}

- (UILabel *)labelWithFont:(CGFloat)font color:(UIColor *)color {
    UILabel *label = [[UILabel alloc] init];
    label.font = [UIFont systemFontOfSize:font];
    label.textColor = color;
    return label;
}

@end
