//
//  CommonDefine.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/9.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#ifndef CommonDefine_h
#define CommonDefine_h

#import <Foundation/Foundation.h>
#import "UIView+layout.h"

#ifdef __cplusplus
extern "C" {
#endif
    
    extern CGRect getScreenFrame();
    extern UIEdgeInsets safeAreaInsets();
    
#ifdef __cplusplus
}
#endif

#define iPhone5 ([UIScreen instancesRespondToSelector:@selector(currentMode)] ? CGSizeEqualToSize(CGSizeMake(640, 1136), [[UIScreen mainScreen] currentMode].size) : NO)
#define iPhoneX ([UIScreen instancesRespondToSelector:@selector(currentMode)] ? (CGSizeEqualToSize(CGSizeMake(1125, 2436), [[UIScreen mainScreen] currentMode].size)) : NO)

#define SAFE_AREA_INSETS_TOP ({\
CGFloat barTopPadding = 0;\
if (iPhoneX) {\
barTopPadding = 44;\
}else{\
barTopPadding = 20;\
}\
(barTopPadding);\
}) //导航栏的上边距

#define SAFE_AREA_INSETS_BOTTOM  ({\
CGFloat bottomMargin = 0;\
if (iPhoneX) {\
bottomMargin = 34;\
}else{\
bottomMargin = 0;\
}\
(bottomMargin);\
})

#define PHONE_SIZE      ([UIScreen mainScreen].bounds.size)
#define PHONE_WIDTH    MIN(PHONE_SIZE.width,PHONE_SIZE.height)
#define ADAPTOR_VALUE_750(_VALUE_)   (int)(((float)PHONE_WIDTH/750)*(_VALUE_) + 0.5)
#define ADAPTOR_VALUE_1242(_VALUE_)   (int)(((float)PHONE_WIDTH/1242)*(_VALUE_) + 0.5)
#define IPHONE_SCREEN_WIDTH      (CGRectGetWidth(getScreenFrame()))
#define IPHONE_SCREEN_HEIGHT     (CGRectGetHeight(getScreenFrame()))
#define CR_MAP_VIEW_ENTRANCE_RIGHT_MARGIN (IPHONE_SCREEN_WIDTH<=375?ADAPTOR_VALUE_750(8):ADAPTOR_VALUE_750(12))

//状态栏高度
#define KStatuesBarHeight  ([UIApplication sharedApplication].statusBarFrame.size.height)
//导航栏高度
#define KNavigationBarHeight 44.0
//导航栏高度+状态栏高度
#define kViewTopHeight (KStatuesBarHeight + KNavigationBarHeight)

#define BGViewBottomOffset (iPhoneX ? (34 - ADAPTOR_VALUE_750(24)) : (IPHONE_SCREEN_WIDTH<=375 ? ADAPTOR_VALUE_750(-24) : ADAPTOR_VALUE_750(-24)))

#define RGBA(r,g,b,a) [UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:a]
#define UIColorFromRGBA(rgbValue, alphaValue) [UIColor colorWithRed:((float)((rgbValue & 0xFF0000) >> 16))/255.0 green:((float)((rgbValue & 0xFF00) >> 8))/255.0 blue:((float)(rgbValue & 0xFF))/255.0 alpha:alphaValue]
#define UIColorFromRGB(rgbValue) UIColorFromRGBA(rgbValue, 1.0f)

#define kThreePanleError_LocationClose                  @"定位服务未开启,"
#define kThreePanleError_LocationFail                   @"定位失败,"
#define kThreePanleError_NetFail                        @"网络不畅,"

#define kRAButtonWidth      (ADAPTOR_VALUE_1242(166)) //72+阴影4*2
#define kRAButtonHeight     (ADAPTOR_VALUE_1242(166))

//没有路况
#define NOROADCONDITION_COLOR UIColorFromRGBA(0x5d88e9,1)
    //畅通
#define STRAIGHTWAY_COLOR UIColorFromRGBA(0x45cc6a,1)
    //缓慢
#define SLOW_COLOR  UIColorFromRGBA(0xffae00,1)
    //拥堵
#define OBSTRUCTION_COLOR UIColorFromRGBA(0xff5453,1)
    //非常拥堵
#define VERY_OBSTRUCTION_COLOR UIColorFromRGBA(0xbf2e22,1)

#endif /* CommonDefine_h */
