//
//  CarThreeTabView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/9.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "CarThreeTabView.h"
#import "BNCarRouteData.h"
#import "MapCommonDefine.h"
#import "StringSizeCache.h"
#import "RouteDataHelper.h"

#define DisLabelFont ([UIFont systemFontOfSize:ADAPTOR_VALUE_750(24)])

@interface CarThreeTabView()

@property (nonatomic, strong) UILabel *timeLabel;
@property (nonatomic, strong) UILabel *disLabel;
@property (nonatomic, strong) UILabel *tipLabel;
@property (nonatomic, strong) UILabel *trafficLabel;//红绿灯
@property (nonatomic, strong) UILabel *tollLabel;//收费
@property (nonatomic, strong) UIImageView *trafficImgView;//红绿灯
@property (nonatomic, strong) UIImageView *tollImgView;//收费
@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, strong) UIView *lineView;
@property (nonatomic, strong) UIView *bottomLineView;

@property (nonatomic, strong) NSMutableDictionary* subViewCacheDict;
@property (nonatomic, strong) StringSizeCache* stringSizeCache;

@end

@implementation CarThreeTabView

- (void)createUICache {
    if (_subViewCacheDict) {
        return;
    }
    
    self.subViewCacheDict[@"bgView"] = [[UIView alloc] initWithFrame:self.bounds];
    self.subViewCacheDict[@"tipLabel"] = [UILabel new];
    self.subViewCacheDict[@"timeLabel"] = [UILabel new];
    self.subViewCacheDict[@"disLabel"] = [UILabel new];
    self.subViewCacheDict[@"trafficImgView"] = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"carscene_trafficlight.png"]];
    self.subViewCacheDict[@"trafficLabel"] = [UILabel new];
    self.subViewCacheDict[@"tollLabel"] = [UILabel new];
    self.subViewCacheDict[@"tollImgView"] = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"carscene_toll.png"]];
    self.subViewCacheDict[@"lineView"] = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 0.5, 25)];
    self.subViewCacheDict[@"bottomLineView"] = [[UIView alloc] init];
}

- (id)getSubViewWithName:(NSString*)name withClassName:(NSString*)className {
    UIView* subView = self.subViewCacheDict[name];
    if (!subView) {
        subView = [[NSClassFromString(className) alloc] init];
        if (subView) {
            self.subViewCacheDict[name] = subView;
        }
    }
    if (subView.hidden) {
        subView.hidden = NO;
    }
    return subView;
}

- (void)resetSubViews {
    _timeLabel = nil;
    _disLabel = nil;
    _tipLabel = nil;
    _trafficLabel = nil;
    _tollLabel = nil;
    _trafficImgView = nil;
    _tollImgView = nil;
    _bgView = nil;
    _lineView = nil;
    _bottomLineView = nil;
}

- (void)sizeToFitLabel:(UILabel*)label {
    if (!label.text || !label.text.length) {
        label.size = CGSizeZero;
    } else {
        CGSize size = [self.stringSizeCache getStringSize:label.text font:label.font];
        size.width = ceil(size.width);
        size.height = ceil(size.height);
        label.size = size;
    }
}

#pragma mark - 红绿灯判断逻辑
- (BOOL)supportShowTrafficLightsWithCurrentRoute:(BNCarOneRouteModel *)oneRoute allRoute:(BNCarRouteModel *)routes {
    if (!routes || !(routes.carRoutes.count > 0)) {
        return NO;
    }
    //是否长途
    if(self.delegate && [self.delegate respondsToSelector:@selector(isLonjounery)]) {
        if ([self.delegate isLonjounery]) {
            return NO;
        }
    }
    //是否某条路线上没有红绿灯
    for (BNCarOneRouteModel * route in routes.carRoutes) {
        if (!(route.lightNum > 0)) {
            return NO;
        }
        //是否距离长度超出导致无法显示红绿灯
        if ([self distanceSizeOverflowWithRoute:route]) {
            return NO;
        }
    }
    
    return YES;
}

- (BOOL)distanceSizeOverflowWithRoute:(BNCarOneRouteModel *)oneRoute{
    if (!oneRoute) {
        return YES;
    }
    NSString *disTip = [RouteDataHelper distanceStringFromMeters:oneRoute.distance];
    CGSize disLabelSize = [self.stringSizeCache getStringSize:disTip font:DisLabelFont];
    
    CGSize trafficLabelSize = CGSizeMake(0, 0);
    if (oneRoute.lightNum > 0) {
        NSString *lightNumStr = [NSString stringWithFormat:@"%ld",(long)oneRoute.lightNum];
        trafficLabelSize = [self.stringSizeCache getStringSize:lightNumStr font:DisLabelFont];
    }
    CGSize tollLabelSize = CGSizeMake(0, 0);
    if (oneRoute.toll > 0) {
        NSString *tollStr = [NSString stringWithFormat:@"%ld",(long)oneRoute.toll];
        tollLabelSize = [self.stringSizeCache getStringSize:tollStr font:DisLabelFont];
    }
    
    int totalWidth = disLabelSize.width+(!(trafficLabelSize.width > 0)?0:(4+9+trafficLabelSize.width))+3+(!(tollLabelSize.width>0)?0:(4+9+tollLabelSize.width));
    if (totalWidth > self.width) {
        return YES;
    }
    return NO;
}

#pragma mark -
- (void)updateWithOneRoute:(BNCarOneRouteModel *)oneRoute capText:(NSString *)capText  allRoute:(BNCarRouteModel*)allRoute {
    [self.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
    [self resetSubViews];
    
    BOOL bShowTraffic = [self supportShowTrafficLightsWithCurrentRoute:oneRoute allRoute:allRoute];
    
    self.backgroundColor = [UIColor clearColor];
    
    self.bottomLineView = [self getSubViewWithName:@"bottomLineView" withClassName:@"UIView"];
    self.bottomLineView.frame = CGRectMake(0, self.height-1, self.width, 0.5);
    self.bottomLineView.backgroundColor = UIColorFromRGB(0xeaeaea);
    self.bottomLineView.centerY = CGRectGetMidY(self.bounds);
    [self addSubview:self.bottomLineView];
    
    _bgView = [self getSubViewWithName:@"bgView" withClassName:@"UIView"];
    _bgView.frame = self.bounds;
    _bgView.height = self.height;
    _bgView.layer.cornerRadius = 2.0f;
    _bgView.layer.masksToBounds = YES;
    [self addSubview:_bgView];
    
    NSString *timeTip = [RouteDataHelper getCarPageTimeDescription:(int)oneRoute.time];
    NSString *disTip = [RouteDataHelper getCarPageDistanceDescription:(int)oneRoute.distance];
    
    NSString *tollStr = [NSString stringWithFormat:@"%ld",(long)oneRoute.toll];
    NSString *lightNumStr = [NSString stringWithFormat:@"%ld",(long)oneRoute.lightNum];
    
    if (capText.length > 0) {
        _tipLabel = [self getSubViewWithName:@"tipLabel" withClassName:@"UILabel"];
        _tipLabel.text = capText;
        _tipLabel.textColor = [UIColor whiteColor];
        _tipLabel.font = [UIFont systemFontOfSize:ADAPTOR_VALUE_750(24)];
        _tipLabel.frame = CGRectMake(0, 0, self.frame.size.width, _tipLabel.font.lineHeight);
        [self addSubview:_tipLabel];
    }
    
    _timeLabel = [self getSubViewWithName:@"timeLabel" withClassName:@"UILabel"];
    _timeLabel.text = timeTip;
    _timeLabel.font = [UIFont boldSystemFontOfSize:ADAPTOR_VALUE_750(36)];
    _timeLabel.textColor = kBlackColor;
    _timeLabel.font = [UIFont systemFontOfSize:ADAPTOR_VALUE_750(38)];
    _timeLabel.frame = CGRectMake(0, 0, self.frame.size.width, _timeLabel.font.lineHeight);
    [self addSubview:_timeLabel];
    
    _disLabel = [self getSubViewWithName:@"disLabel" withClassName:@"UILabel"];
    _disLabel.text = disTip;
    _disLabel.font = DisLabelFont;
    _disLabel.textColor = kBlackColor;
    _disLabel.frame = CGRectMake(0, 0, self.frame.size.width, _disLabel.font.lineHeight);
    [self addSubview:_disLabel];
    
    if(bShowTraffic && oneRoute.lightNum > 0) {
        _trafficImgView = [self getSubViewWithName:@"trafficImgView" withClassName:@"UIImageView"];
        _trafficImgView.image = [UIImage imageNamed:@"carscene_trafficlight.png"];
        [self addSubview:_trafficImgView];
        
        _trafficLabel = [self getSubViewWithName:@"trafficLabel" withClassName:@"UILabel"];
        _trafficLabel.text = lightNumStr;
        _trafficLabel.font = DisLabelFont;
        _trafficLabel.textColor = kBlackColor;
        [self addSubview:_trafficLabel];
        _trafficLabel.frame = CGRectMake(0, 0, self.frame.size.width, _trafficLabel.font.lineHeight);
    }
    
    _tollLabel = [self getSubViewWithName:@"tollLabel" withClassName:@"UILabel"];
    _tollLabel.text = tollStr;
    _tollLabel.font = DisLabelFont;
    _tollLabel.textColor = kBlackColor;
    _tollLabel.frame = CGRectMake(0, 0, self.frame.size.width, _tollLabel.font.lineHeight);
    if(oneRoute.toll > 0) {
        [self addSubview:_tollLabel];
    }
    
    _tollImgView = [self getSubViewWithName:@"tollImgView" withClassName:@"UIImageView"];
    _tollImgView.image = [UIImage imageNamed:@"carscene_toll.png"];
    if(oneRoute.toll > 0) {
        [self addSubview:_tollImgView];
    }
    
    _lineView = [self getSubViewWithName:@"lineView" withClassName:@"UIView"];
    _lineView.frame = CGRectMake(0, 0, 0.5, 25);
    _lineView.backgroundColor = UIColorFromRGB(0xd7d8d9);
    _lineView.centerY = CGRectGetMidY(self.bounds);
    _lineView.hidden = YES;
}

- (void)updateSigle {
    CGFloat height = ADAPTOR_VALUE_750(132);
    CGFloat width = ADAPTOR_VALUE_750(750);
    self.frame = CGRectMake(0, 0, width, height);
    
    _tipLabel.textColor = [UIColor whiteColor];
    _timeLabel.textColor = kBlackColor;
    _disLabel.textColor = kBlackColor;
    
    _tipLabel.font = [UIFont systemFontOfSize:ADAPTOR_VALUE_750(22)];
    _timeLabel.font = [UIFont boldSystemFontOfSize:ADAPTOR_VALUE_750(38)];
    _disLabel.font = [UIFont boldSystemFontOfSize:ADAPTOR_VALUE_750(38)];
    _trafficLabel.font = DisLabelFont;
    _tollLabel.font = DisLabelFont;
    [self sizeToFitLabel:_timeLabel];
    [self sizeToFitLabel:_disLabel];
    
    self.timeLabel.left = ADAPTOR_VALUE_750(30)-5;
    self.timeLabel.top =  ADAPTOR_VALUE_750(30);
    
    self.disLabel.left = CGRectGetMaxX(self.timeLabel.frame) + 11.0f;
    self.disLabel.top = self.timeLabel.top;
    
    self.tipLabel.hidden = YES;
    
    self.bottomLineView.frame = CGRectMake(0, self.height-1, self.width, 0.5);
    
    if (self.trafficImgView) {
        self.trafficImgView.left = self.timeLabel.left;
        self.trafficImgView.top = self.timeLabel.bottom+5;
        self.trafficImgView.size = self.trafficImgView.image.size;
        self.trafficLabel.left = self.trafficImgView.right+1;
        self.trafficLabel.top = self.trafficImgView.top;
        CGSize trafficSize = [self.stringSizeCache getStringSize:self.trafficLabel.text font:self.trafficLabel.font];
        self.trafficLabel.size = CGSizeMake(trafficSize.width , self.trafficImgView.height);
    }
    
    if (self.tollLabel.superview) {
        self.tollImgView.left = self.trafficLabel?self.trafficLabel.right+3:self.timeLabel.left;
        self.tollImgView.top = self.timeLabel.bottom+5;
        self.tollImgView.size = self.tollImgView.image.size;
        
        self.tollLabel.left = self.tollImgView.right+1;
        self.tollLabel.top = self.tollImgView.top;
        CGSize tollSize = [self.stringSizeCache getStringSize:self.tollLabel.text font:self.tollLabel.font];
        self.tollLabel.size = CGSizeMake(tollSize.width ,self.tollImgView.height+1);
    }

    if(!_trafficImgView && _tollImgView.superview==nil) {
        self.timeLabel.top = (self.height-self.timeLabel.size.height)/2;
        self.disLabel.top = self.timeLabel.top;
    }
}

- (void)updateMulti {
    CGFloat centerX = CGRectGetMidX(self.bounds);
    
    self.tipLabel.textAlignment = NSTextAlignmentCenter;
    self.tipLabel.top = ADAPTOR_VALUE_750(28);
    self.tipLabel.centerX = centerX;
    
    self.timeLabel.top = CGRectGetMaxY(self.tipLabel.frame) + ADAPTOR_VALUE_750(9);
    self.timeLabel.centerX = centerX+1;
    self.timeLabel.textAlignment = NSTextAlignmentCenter;
    self.disLabel.bottom = self.height - ADAPTOR_VALUE_750(22);
    self.disLabel.textAlignment = NSTextAlignmentCenter;
    
    CGSize disLabelSize = [self.stringSizeCache getStringSize:self.disLabel.text font:self.disLabel.font];
    CGSize trafficLabelSize = {0,0};
    CGSize tollLabelSize = {0,0};
    if (self.trafficLabel) {
        trafficLabelSize = [self.stringSizeCache getStringSize:self.trafficLabel.text font:self.trafficLabel.font];
    }
    
    if (self.tollLabel.superview) {
        tollLabelSize = [self.stringSizeCache getStringSize:self.tollLabel.text font:self.tollLabel.font];
    }
    
    int totalWidth = disLabelSize.width
    +(self.trafficLabel==nil?0:(4+9+trafficLabelSize.width))
    +3+
    +(self.tollLabel.superview==nil?0:(4+9+tollLabelSize.width));
    int left = (self.width-totalWidth)/2;
    self.disLabel.left = left;
    self.disLabel.width = disLabelSize.width+2;
    
    if (self.trafficImgView) {
        self.trafficImgView.left = self.disLabel.right+4;
        if(iPhone5)
            self.trafficImgView.bottom = self.disLabel.bottom;
        else
            self.trafficImgView.top = self.disLabel.top+3;
        
        self.trafficImgView.size = self.trafficImgView.image.size;
        
        self.trafficLabel.left = self.trafficImgView.right+1;
        self.trafficLabel.bottom = self.disLabel.bottom;
        self.trafficLabel.size = CGSizeMake(trafficLabelSize.width , self.disLabel.height);
    }
    
    if (self.tollLabel.superview) {
        self.tollImgView.left = self.trafficLabel?self.trafficLabel.right+3:self.disLabel.right+3;
        if(iPhone5)
            self.tollImgView.bottom = self.disLabel.bottom-1;
        else
            self.tollImgView.top = self.disLabel.top+3;
        
        self.tollImgView.size = self.tollImgView.image.size;
        
        self.tollLabel.left = self.tollImgView.right+1;
        self.tollLabel.bottom = self.disLabel.bottom;
        self.tollLabel.size = tollLabelSize;
    }

    self.selected = NO;
}

- (void)setBeenSelected:(BOOL)beenSelected {
    _beenSelected = beenSelected;
    if (beenSelected) {
        self.tipLabel.textColor = UIColorFromRGB(0x3385ff);
        self.timeLabel.textColor = UIColorFromRGB(0x3385ff);
        self.disLabel.textColor = UIColorFromRGB(0x3385ff);
        self.trafficLabel.textColor = self.disLabel.textColor;
        self.tollLabel.textColor = self.disLabel.textColor;
        self.timeLabel.font = [UIFont boldSystemFontOfSize:ADAPTOR_VALUE_750(36)];
        self.trafficImgView.image = [UIImage imageNamed:@"carscene_trafficlight_sel.png"];
        self.tollImgView.image = [UIImage imageNamed:@"carscene_toll_sel.png"];
    } else {
        self.tipLabel.textColor = UIColorFromRGB(0x666666);
        self.timeLabel.textColor = UIColorFromRGB(0x333333);
        self.timeLabel.font = [UIFont boldSystemFontOfSize:ADAPTOR_VALUE_750(36)];
        self.disLabel.textColor = UIColorFromRGB(0x333333);
        self.trafficLabel.textColor = self.disLabel.textColor;
        self.tollLabel.textColor = self.disLabel.textColor;
        self.trafficImgView.image = [UIImage imageNamed:@"carscene_trafficlight.png"];
        self.tollImgView.image = [UIImage imageNamed:@"carscene_toll.png"];
    }
}

- (void)hideLine:(BOOL)hidden {
    if (self.lineView.hidden != hidden) {
        self.lineView.hidden = hidden;
    }
}

- (NSString *)getTimeValue {
    return _timeLabel.text;
}

- (NSString *)getDistanceValue {
    return _disLabel.text;
}

- (void)updateTimeWithOneRoute:(BNCarOneRouteModel *)oneRoute {
    NSString *timeTip = [RouteDataHelper seconds2HourAndMinDescription:oneRoute.time];
    _timeLabel.text = timeTip;
    [_timeLabel sizeToFit];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    _bottomLineView = [self getSubViewWithName:@"bottomLineView" withClassName:@"UIView"];
    _bottomLineView.frame = CGRectMake(0, self.height-0.5, self.width, 0.5);
    [self bringSubviewToFront:_bottomLineView];
}

#pragma mark - Lazy loading
- (NSMutableDictionary *)subViewCacheDict {
    if (!_subViewCacheDict) {
        _subViewCacheDict = [[NSMutableDictionary alloc] init];
    }
    return _subViewCacheDict;
}

- (StringSizeCache *)stringSizeCache {
    if (!_stringSizeCache) {
        _stringSizeCache = [[StringSizeCache alloc] init];
    }
    return _stringSizeCache;
}

@end
