//
//  CarThreeTabView.h
//  NaviDemo
//
//  Created by linbiao on 2019/5/9.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>

#define kBlackColor (UIColorFromRGB(0x333333))
#define kBlueColor  (UIColorFromRGB(0x61c27a))
#define kGreyColor  (UIColorFromRGB(0xcccccc))

@class BNCarRouteModel;
@class BNCarOneRouteModel;

@protocol CarThreeTabViewDelegate <NSObject>

- (BOOL)isLonjounery;

@end

@interface CarThreeTabView : UIControl

@property (nonatomic, weak) id<CarThreeTabViewDelegate>delegate;
@property (nonatomic, assign) BOOL beenSelected;

- (void)updateWithOneRoute:(BNCarOneRouteModel *)oneRoute capText:(NSString *)capText allRoute:(BNCarRouteModel*)allRoute;
- (void)updateSigle;
- (void)updateMulti;
- (void)hideLine:(BOOL)hidden;
- (void)updateTimeWithOneRoute:(BNCarOneRouteModel *)oneRoute;

- (void)createUICache;

- (NSString *)getTimeValue;
- (NSString *)getDistanceValue;

@end
