//
//  WeakTimerTarget.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/13.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "WeakTimerTarget.h"

@interface WeakTimerTarget ()
{
    __weak id _target;
    SEL _selector;
}

@end

@implementation WeakTimerTarget

- (instancetype) initWithTarget:(id)target andSelector:(SEL)selector {
    self = [super init];
    if (self) {
        _target = target;
        _selector = selector;
    }
    return self;
}

- (void) dealloc {
    
}

- (void)timerDidFire:(NSTimer *)timer {
    if(_target) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"
        [_target performSelector:_selector withObject:timer];
#pragma clang diagnostic pop
    } else {
        [timer invalidate];
    }
}

@end
